/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import com.google.protobuf.ByteString;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.persist.adapter.ImmutableHeadsAndForkPoints;
import org.projectnessie.versioned.transfer.CommitLogOptimization;
import org.projectnessie.versioned.transfer.ImportResult;
import org.projectnessie.versioned.transfer.NessieImporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.files.FileImporter;
import org.projectnessie.versioned.transfer.files.ImportFileSupplier;
import org.projectnessie.versioned.transfer.files.ZipArchiveImporter;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;
import picocli.CommandLine;

@CommandLine.Command(name="import", mixinStandardHelpOptions=true, description={"Imports a Nessie repository from the local file system."})
public class ImportRepository
extends BaseCommand {
    static final String PATH = "--path";
    static final String ERASE_BEFORE_IMPORT = "--erase-before-import";
    static final String NO_OPTIMIZE = "--no-optimize";
    static final String INPUT_BUFFER_SIZE = "--input-buffer-size";
    static final String COMMIT_BATCH_SIZE = "--commit-batch-size";
    @CommandLine.Option(names={"-p", "--path"}, paramLabel="<import-from>", required=true, description={"The ZIP file or directory to read the export from.", "If this parameter refers to a file, the import will assume that it is a ZIP file, otherwise a directory."})
    private Path path;
    @CommandLine.Option(names={"--commit-batch-size"}, description={"Batch size when writing commits, defaults to 20."})
    private Integer commitBatchSize;
    @CommandLine.Option(names={"--input-buffer-size"}, description={"Input buffer size, defaults to 32768."})
    private Integer inputBufferSize;
    @CommandLine.Option(names={"--no-optimize"}, description={"Do not run commit log optimization after importing the repository."})
    private boolean noOptimize;
    @CommandLine.Option(names={"-e", "--erase-before-import"}, description={"Erase an existing repository before the import is started.", "This will delete all previously existing Nessie data.", "Using this option has no effect, if the Nessie repository does not already exist."})
    private boolean erase;

    @Override
    protected Integer callWithDatabaseAdapter() throws Exception {
        this.warnOnInMemory();
        try (ImportFileSupplier importFileSupplier = this.createImportFileSupplier();){
            NessieImporter.Builder builder = NessieImporter.builder().importFileSupplier(importFileSupplier).databaseAdapter(this.databaseAdapter);
            if (this.commitBatchSize != null) {
                builder.commitBatchSize(this.commitBatchSize.intValue());
            }
            PrintWriter out = this.spec.commandLine().getOut();
            if (!this.erase) {
                try (Stream refs = this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);
                     Stream commits = this.databaseAdapter.scanAllCommitLogEntries();){
                    AtomicReference ref = new AtomicReference();
                    long refCount = refs.peek(ref::set).count();
                    boolean hasCommit = commits.findAny().isPresent();
                    if (hasCommit || refCount > 1L || refCount == 1L && !((ReferenceInfo)ref.get()).getHash().equals(this.databaseAdapter.noAncestorHash())) {
                        this.spec.commandLine().getErr().println("The Nessie repository already exists and is not empty, aborting. Provide the --erase-before-import option if you want to erase the repository.");
                        Integer n = 100;
                        return n;
                    }
                }
            }
            ImportResult importResult = builder.progressListener((ProgressListener)new ImportProgressListener(out)).build().importNessieRepository();
            out.printf("Imported Nessie repository, %d commits, %d named references.%n", importResult.importedCommitCount(), importResult.importedReferenceCount());
            if (!this.noOptimize) {
                out.println("Optimizing...");
                CommitLogOptimization.builder().headsAndForks(ImportRepository.toHeadsAndForkPoints(importResult.headsAndForks())).databaseAdapter(this.databaseAdapter).build().optimize();
                out.println("Finished commit log optimization.");
            }
            Integer n = 0;
            return n;
        }
    }

    static HeadsAndForkPoints toHeadsAndForkPoints(TransferTypes.HeadsAndForks headsAndForks) {
        ImmutableHeadsAndForkPoints.Builder hfBuilder = ImmutableHeadsAndForkPoints.builder().scanStartedAtInMicros(headsAndForks.getScanStartedAtInMicros());
        headsAndForks.getHeadsList().forEach(h -> hfBuilder.addHeads(Hash.of((ByteString)h)));
        headsAndForks.getForkPointsList().forEach(h -> hfBuilder.addForkPoints(Hash.of((ByteString)h)));
        return hfBuilder.build();
    }

    private ImportFileSupplier createImportFileSupplier() {
        ZipArchiveImporter importFileSupplier;
        if (Files.isRegularFile(this.path, new LinkOption[0])) {
            importFileSupplier = ZipArchiveImporter.builder().sourceZipFile(this.path).build();
        } else if (Files.isDirectory(this.path, new LinkOption[0])) {
            FileImporter.Builder b = FileImporter.builder().sourceDirectory(this.path);
            if (this.inputBufferSize != null) {
                b.inputBufferSize(this.inputBufferSize.intValue());
            }
            importFileSupplier = b.build();
        } else {
            throw new CommandLine.PicocliException(String.format("No such file or directory %s", this.path));
        }
        return importFileSupplier;
    }

    private static final class ImportProgressListener
    implements ProgressListener {
        private final PrintWriter out;
        private int count;
        private boolean dot;
        private TransferTypes.ExportMeta exportMeta;

        public ImportProgressListener(PrintWriter out) {
            this.out = out;
        }

        public void progress(@Nonnull ProgressEvent progress, TransferTypes.ExportMeta meta) {
            switch (progress) {
                case START_PREPARE: {
                    this.out.printf("Preparing repository...%n", new Object[0]);
                    this.dot = false;
                    break;
                }
                case END_PREPARE: {
                    break;
                }
                case END_META: {
                    this.exportMeta = meta;
                    String nessieVersion = meta.getNessieVersion();
                    if (nessieVersion.isEmpty()) {
                        nessieVersion = "(unknown, before 0.46)";
                    }
                    this.out.printf("Export was created by Nessie version %s on %s, containing %d named references (in %d files) and %d commits (in %d files).%n", nessieVersion, Instant.ofEpochMilli(meta.getCreatedMillisEpoch()), meta.getNamedReferencesCount(), meta.getNamedReferencesFilesCount(), meta.getCommitCount(), meta.getCommitsFilesCount());
                    break;
                }
                case START_COMMITS: {
                    this.out.printf("Importing %d commits...%n", this.exportMeta.getCommitCount());
                    this.count = 0;
                    this.dot = false;
                    break;
                }
                case END_COMMITS: {
                    if (this.dot) {
                        this.out.println();
                    }
                    this.out.printf("%d commits imported.%n%n", this.count);
                    break;
                }
                case START_NAMED_REFERENCES: {
                    this.out.printf("Importing %d named references...%n", this.exportMeta.getNamedReferencesCount());
                    this.count = 0;
                    this.dot = false;
                    break;
                }
                case COMMIT_WRITTEN: 
                case NAMED_REFERENCE_WRITTEN: {
                    ++this.count;
                    if (this.count % 10 == 0) {
                        this.out.print('.');
                        this.dot = true;
                    }
                    if (this.count % 500 != 0) break;
                    this.out.printf(" %d%n", this.count);
                    this.dot = false;
                    break;
                }
                case END_NAMED_REFERENCES: {
                    if (this.dot) {
                        this.out.println();
                    }
                    this.out.printf("%d named references imported.%n%n", this.count);
                    break;
                }
            }
        }
    }
}

