/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import java.util.stream.Collectors;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import picocli.CommandLine;

@CommandLine.Command(name="info", mixinStandardHelpOptions=true, description={"Nessie repository information"})
public class NessieInfo
extends BaseCommand {
    @Override
    protected Integer callWithDatabaseAdapter() throws Exception {
        this.warnOnInMemory();
        ReferenceInfo refInfo = this.databaseAdapter.namedRef(this.serverConfig.getDefaultBranch(), (GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).build());
        RepoDescription repoDesc = this.databaseAdapter.fetchRepositoryDescription();
        this.spec.commandLine().getOut().printf("%nNo-ancestor hash:                  %s%nDefault branch head commit ID:     %s%nDefault branch commit count:       %s%nRepository description version:    %d%nRepository description properties: %s%n%nFrom configuration:%n-------------------%nVersion-store type:                %s%nDefault branch:                    %s%n", this.databaseAdapter.noAncestorHash().asString(), refInfo.getHash().asString(), refInfo.getCommitSeq(), repoDesc.getRepoVersion(), repoDesc.getProperties().entrySet().stream().map(e -> String.format("%-30s = %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n                                   ")), this.versionStoreConfig.getVersionStoreType(), this.serverConfig.getDefaultBranch());
        return 0;
    }
}

