/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.tests.profiles;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;

public class PostgresTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private JdbcDatabaseContainer<?> container;

    public Map<String, String> start() {
        String version = System.getProperty("it.nessie.container.postgres.tag", "9.6.22");
        this.container = new PostgreSQLContainer("postgres:" + version);
        try {
            this.container.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ImmutableMap.of((Object)"quarkus.datasource.username", (Object)this.container.getUsername(), (Object)"quarkus.datasource.password", (Object)this.container.getPassword(), (Object)"quarkus.datasource.jdbc.url", (Object)this.container.getJdbcUrl(), (Object)"quarkus.datasource.jdbc.extended-leak-report", (Object)"true");
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.container = null;
            }
        }
    }
}

