/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.tests.profiles;

import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.projectnessie.versioned.persist.dynamodb.LocalDynamoTestConnectionProviderSource;

public class DynamoTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager,
DevServicesContext.ContextAware {
    private LocalDynamoTestConnectionProviderSource dynamo;
    private Optional<String> containerNetworkId = Optional.empty();

    public void setIntegrationTestContext(DevServicesContext context) {
        this.containerNetworkId = context.containerNetworkId();
    }

    public Map<String, String> start() {
        this.dynamo = new LocalDynamoTestConnectionProviderSource();
        try {
            this.dynamo.startDynamo(this.containerNetworkId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return Collections.singletonMap("quarkus.dynamodb.endpoint-override", this.dynamo.getEndpointURI());
    }

    public void stop() {
        if (this.dynamo != null) {
            try {
                this.dynamo.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.dynamo = null;
            }
        }
    }
}

