/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.tests.profiles;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;

public class PostgresTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager,
DevServicesContext.ContextAware {
    private JdbcDatabaseContainer<?> container;
    private Optional<String> containerNetworkId;

    public void setIntegrationTestContext(DevServicesContext context) {
        this.containerNetworkId = context.containerNetworkId();
    }

    public Map<String, String> start() {
        String version = System.getProperty("it.nessie.container.postgres.tag");
        if (version == null) {
            throw new RuntimeException("postgres container version is not specified. Please configure it using the system property it.nessie.container.postgres.tag");
        }
        this.container = (JdbcDatabaseContainer)((PostgreSQLContainer)new PostgreSQLContainer("postgres:" + version).withLogConsumer(outputFrame -> {})).withStartupAttempts(5);
        this.containerNetworkId.ifPresent(arg_0 -> this.container.withNetworkMode(arg_0));
        try {
            this.container.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String jdbcUrl = this.container.getJdbcUrl();
        if (this.containerNetworkId.isPresent()) {
            String hostPort = this.container.getHost() + ":" + this.container.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue());
            String networkHostPort = this.container.getCurrentContainerInfo().getConfig().getHostName() + ":" + PostgreSQLContainer.POSTGRESQL_PORT;
            jdbcUrl = jdbcUrl.replace(hostPort, networkHostPort);
        }
        return ImmutableMap.of((Object)"quarkus.datasource.username", (Object)this.container.getUsername(), (Object)"quarkus.datasource.password", (Object)this.container.getPassword(), (Object)"quarkus.datasource.jdbc.url", (Object)jdbcUrl, (Object)"quarkus.datasource.jdbc.extended-leak-report", (Object)"true");
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.container = null;
            }
        }
    }
}

