/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server;

import com.dremio.nessie.api.ContentsApi;
import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.client.rest.NessieForbiddenException;
import com.dremio.nessie.client.rest.NessieNotAuthorizedException;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.IcebergTable;
import com.dremio.nessie.model.ImmutableBranch;
import com.dremio.nessie.model.ImmutableIcebergTable;
import com.dremio.nessie.model.Reference;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.security.TestSecurity;
import java.io.IOException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

@QuarkusTest
class TestAuth {
    private NessieClient client;
    private TreeApi tree;
    private ContentsApi contents;

    TestAuth() {
    }

    void getCatalog(String branch) throws NessieNotFoundException, NessieConflictException {
        String path = "http://localhost:19121/api/v1";
        this.client = new NessieClient(NessieClient.AuthType.NONE, path, null, null);
        this.tree = this.client.getTreeApi();
        this.contents = this.client.getContentsApi();
        if (branch != null) {
            this.tree.createEmptyBranch(branch);
        }
    }

    void tryEndpointPass(Executable runnable) {
        Assertions.assertDoesNotThrow((Executable)runnable);
    }

    void tryEndpointFail(Executable runnable) {
        Assertions.assertThrows(NessieForbiddenException.class, (Executable)runnable);
    }

    @Disabled
    @Test
    void testLogin() {
        Assertions.assertThrows(NessieNotAuthorizedException.class, () -> this.getCatalog("x"));
    }

    @Test
    @TestSecurity(user="admin_user", roles={"admin", "user"})
    void testAdmin() throws NessieNotFoundException, NessieConflictException {
        this.getCatalog("testx");
        Branch branch = (Branch)this.tree.getReferenceByName("testx");
        List tables = this.tree.getEntries("testx").getEntries();
        Assertions.assertTrue((boolean)tables.isEmpty());
        ContentsKey key = ContentsKey.of((String[])new String[]{"x", "x"});
        this.tryEndpointPass(() -> this.contents.setContents(key, branch.getName(), branch.getHash(), "empty message", (Contents)IcebergTable.of((String)"foo")));
        IcebergTable table = (IcebergTable)this.contents.getContents(key, "testx").unwrap(IcebergTable.class).get();
        Branch master = (Branch)this.tree.getReferenceByName("testx");
        ImmutableBranch test = ImmutableBranch.builder().hash(master.getHash()).name("testy").build();
        this.tryEndpointPass(() -> this.lambda$testAdmin$2((Branch)test));
        Branch test2 = (Branch)this.tree.getReferenceByName("testy");
        this.tryEndpointPass(() -> this.tree.deleteBranch(test2.getName(), test2.getHash()));
        this.tryEndpointPass(() -> this.contents.deleteContents(key, master.getName(), master.getHash(), ""));
        Assertions.assertThrows(NessieNotFoundException.class, () -> this.contents.getContents(key, "testx"));
        this.tryEndpointPass(() -> this.contents.setContents(key, branch.getName(), branch.getHash(), "", (Contents)IcebergTable.of((String)"bar")));
    }

    @Test
    @TestSecurity(authorizationEnabled=false)
    void testUserCleanup() throws NessieNotFoundException, NessieConflictException {
        this.getCatalog(null);
        Reference r = this.client.getTreeApi().getReferenceByName("testx");
        this.client.getTreeApi().deleteBranch(r.getName(), r.getHash());
    }

    private IcebergTable createTable(String name, String location) {
        return ImmutableIcebergTable.builder().metadataLocation("xxx").build();
    }

    private /* synthetic */ void lambda$testAdmin$2(Branch test) throws Throwable {
        this.tree.createNewBranch(test.getName(), test.getHash());
    }

    static interface RunnableIO {
        public void run() throws IOException;
    }
}

