/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server.providers;

import com.dremio.nessie.backend.Backend;
import com.dremio.nessie.model.CommitMeta;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.server.config.ApplicationConfig;
import com.dremio.nessie.server.config.converters.VersionStoreType;
import com.dremio.nessie.server.providers.TableCommitMetaStoreWorker;
import com.dremio.nessie.services.config.ServerConfig;
import com.dremio.nessie.versioned.BranchName;
import com.dremio.nessie.versioned.NamedRef;
import com.dremio.nessie.versioned.ReferenceAlreadyExistsException;
import com.dremio.nessie.versioned.ReferenceNotFoundException;
import com.dremio.nessie.versioned.StoreWorker;
import com.dremio.nessie.versioned.VersionStore;
import com.dremio.nessie.versioned.impl.DynamoStore;
import com.dremio.nessie.versioned.impl.DynamoStoreConfig;
import com.dremio.nessie.versioned.impl.DynamoVersionStore;
import com.dremio.nessie.versioned.impl.JGitVersionStore;
import com.dremio.nessie.versioned.impl.experimental.NessieRepository;
import com.dremio.nessie.versioned.memory.InMemoryVersionStore;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

@Singleton
public class VersionStoreFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionStoreFactory.class);
    private final ApplicationConfig config;
    @ConfigProperty(name="quarkus.dynamodb.aws.region")
    String region;
    @ConfigProperty(name="quarkus.dynamodb.endpoint-override")
    Optional<String> endpoint;

    @Inject
    public VersionStoreFactory(ApplicationConfig config) {
        this.config = config;
    }

    @Produces
    public StoreWorker<Contents, CommitMeta> worker() {
        return new TableCommitMetaStoreWorker();
    }

    @Produces
    @Singleton
    public VersionStore<Contents, CommitMeta> configuration(TableCommitMetaStoreWorker storeWorker, Repository repository, ServerConfig config) {
        VersionStore<Contents, CommitMeta> store = this.getVersionStore(storeWorker, repository);
        if (!store.getNamedRefs().findFirst().isPresent()) {
            try {
                store.create((NamedRef)BranchName.of((String)config.getDefaultBranch()), Optional.empty());
            }
            catch (ReferenceAlreadyExistsException | ReferenceNotFoundException e) {
                LOGGER.warn("Failed to create default branch of {}.", (Object)config.getDefaultBranch(), (Object)e);
            }
        }
        return store;
    }

    private VersionStore<Contents, CommitMeta> getVersionStore(TableCommitMetaStoreWorker storeWorker, Repository repository) {
        switch (this.config.getVersionStoreConfig().getVersionStoreType()) {
            case DYNAMO: {
                LOGGER.info("Using Dyanmo Version store");
                return new DynamoVersionStore((StoreWorker)storeWorker, this.dyanamo(), false);
            }
            case JGIT: {
                LOGGER.info("Using JGit Version Store");
                return new JGitVersionStore(repository, (StoreWorker)storeWorker);
            }
            case INMEMORY: {
                LOGGER.info("Using In Memory version store");
                return InMemoryVersionStore.builder().metadataSerializer(storeWorker.getMetadataSerializer()).valueSerializer(storeWorker.getValueSerializer()).build();
            }
        }
        throw new RuntimeException(String.format("unknown jgit repo type %s", new Object[]{this.config.getVersionStoreConfig().getVersionStoreType()}));
    }

    private DynamoStore dyanamo() {
        if (!this.config.getVersionStoreConfig().getVersionStoreType().equals((Object)VersionStoreType.DYNAMO)) {
            return null;
        }
        DynamoStore dynamo = new DynamoStore((DynamoStoreConfig)DynamoStoreConfig.builder().endpoint(this.endpoint.map(e -> {
            try {
                return new URI((String)e);
            }
            catch (URISyntaxException uriSyntaxException) {
                throw new RuntimeException(uriSyntaxException);
            }
        })).region(Region.of((String)this.region)).initializeDatabase(this.config.getVersionStoreDynamoConfig().isDynamoInitialize()).refTableName(this.config.getVersionStoreDynamoConfig().getRefTableName()).treeTableName(this.config.getVersionStoreDynamoConfig().getTreeTableName()).valueTableName(this.config.getVersionStoreDynamoConfig().getValueTableName()).build());
        dynamo.start();
        return dynamo;
    }

    @Produces
    public Repository repository(Backend backend) throws IOException, GitAPIException {
        if (!this.config.getVersionStoreConfig().getVersionStoreType().equals((Object)VersionStoreType.JGIT)) {
            return null;
        }
        switch (this.config.getVersionStoreJGitConfig().getJgitStoreType()) {
            case DYNAMO: {
                LOGGER.info("JGit Version store has been configured with the dynamo backend");
                DfsRepositoryDescription repoDesc = new DfsRepositoryDescription();
                return ((NessieRepository.Builder)new NessieRepository.Builder().setRepositoryDescription(repoDesc)).setBackend(backend.gitBackend()).setRefBackend(backend.gitRefBackend()).build();
            }
            case DISK: {
                LOGGER.info("JGit Version store has been configured with the file backend");
                File jgitDir = new File(this.config.getVersionStoreJGitConfig().getJgitDirectory().orElseThrow(() -> new RuntimeException("Please set nessie.version.store.jgit.directory")));
                if (!jgitDir.exists() && !jgitDir.mkdirs()) {
                    throw new RuntimeException(String.format("Couldn't create file at %s", this.config.getVersionStoreJGitConfig().getJgitDirectory().get()));
                }
                LOGGER.info(String.format("File backend is at %s", jgitDir.getAbsolutePath()));
                return Git.init().setDirectory(jgitDir).call().getRepository();
            }
            case INMEMORY: {
                LOGGER.info("JGit Version store has been configured with the in memory backend");
                return ((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription())).build();
            }
        }
        throw new RuntimeException(String.format("unknown jgit repo type %s", new Object[]{this.config.getVersionStoreJGitConfig().getJgitStoreType()}));
    }
}

