/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;

public abstract class BaseClientAuthTest {
    private NessieApiV1 api;
    private Consumer<HttpClientBuilder> customizer;

    @AfterEach
    void closeClient() {
        if (this.api != null) {
            this.api.close();
            this.api = null;
        }
    }

    protected void withClientCustomizer(Consumer<HttpClientBuilder> customizer) {
        this.customizer = customizer;
    }

    protected NessieApiV1 api() {
        if (this.api != null) {
            return this.api;
        }
        HttpClientBuilder builder = HttpClientBuilder.builder().withUri("http://localhost:19121/api/v1");
        if (this.customizer != null) {
            this.customizer.accept(builder);
        }
        this.api = (NessieApiV1)builder.build(NessieApiV1.class);
        return this.api;
    }
}

