/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.projectnessie.server.config.VersionStoreConfig;
import org.projectnessie.server.providers.StoreType;
import org.projectnessie.server.providers.VersionStoreFactory;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.rocks.RocksDatabaseAdapterFactory;
import org.projectnessie.versioned.persist.rocks.RocksDbInstance;
import org.projectnessie.versioned.persist.store.PersistVersionStore;

@StoreType(value=VersionStoreConfig.VersionStoreType.ROCKS)
@Dependent
public class RocksVersionStoreFactory
implements VersionStoreFactory {
    @Inject
    RocksDbInstance rocksDbInstance;
    @Inject
    NonTransactionalDatabaseAdapterConfig config;

    @Override
    public <VALUE, METADATA, VALUE_TYPE extends Enum<VALUE_TYPE>> VersionStore<VALUE, METADATA, VALUE_TYPE> newStore(StoreWorker<VALUE, METADATA, VALUE_TYPE> worker, ServerConfig serverConfig) {
        DatabaseAdapter databaseAdapter = new RocksDatabaseAdapterFactory().newBuilder().withConfig((Object)this.config).withConnector((Object)this.rocksDbInstance).build();
        databaseAdapter.initializeRepo(serverConfig.getDefaultBranch());
        return new PersistVersionStore(databaseAdapter, worker);
    }
}

