/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.security.TestSecurity;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentsBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.rest.NessieForbiddenException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableDelete;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.server.BaseClientAuthTest;
import org.projectnessie.server.authz.NessieAuthorizationTestProfile;

@QuarkusTest
@TestProfile(value=NessieAuthorizationTestProfile.class)
class TestAuthorizationRules
extends BaseClientAuthTest {
    TestAuthorizationRules() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @TestSecurity(user="test_user")
    void testAllOpsWithTestUser(boolean shouldFail) throws NessieNotFoundException, NessieConflictException {
        this.testAllOps("allowedBranchForTestUser", "test_user", shouldFail);
    }

    @Test
    @TestSecurity(user="admin_user")
    void testAdminUserIsAllowedEverything() throws NessieNotFoundException, NessieConflictException {
        this.testAllOps("testAdminUserIsAllowedAllBranch", "admin_user", false);
    }

    private void testAllOps(String branchName, String role, boolean shouldFail) throws NessieConflictException, NessieNotFoundException {
        ContentsKey key = ContentsKey.of((String[])new String[]{"allowed", "x"});
        if (shouldFail) {
            branchName = "disallowedBranchForTestUser";
            key = ContentsKey.of((String[])new String[]{"disallowed", "x"});
        }
        this.createBranch(Branch.of((String)branchName, null), role, shouldFail);
        Branch branchWithInvalidHash = Branch.of((String)branchName, (String)"1234567890123456");
        Branch branch = shouldFail ? branchWithInvalidHash : this.retrieveBranch(branchName, role, shouldFail);
        this.listAllReferences(branchName, shouldFail);
        String cid = "cid-foo-" + UUID.randomUUID();
        this.addContent(branch, Operation.Put.of((ContentsKey)key, (Contents)IcebergTable.of((String)"foo", (String)"x", (String)cid)), role, shouldFail);
        if (!shouldFail) {
            this.getCommitLog(branchName, role, shouldFail);
            this.getEntriesFor(branchName, role, shouldFail);
            this.readContent(branchName, key, role, shouldFail);
        }
        branch = shouldFail ? branchWithInvalidHash : this.retrieveBranch(branchName, role, shouldFail);
        this.deleteContent(branch, Operation.Delete.of((ContentsKey)key), role, shouldFail);
        branch = shouldFail ? branchWithInvalidHash : this.retrieveBranch(branchName, role, shouldFail);
        this.deleteBranch(branch, role, shouldFail);
    }

    @Test
    @TestSecurity(user="test_user2")
    void testCanCommitButNotUpdateOrDeleteEntity() throws NessieNotFoundException, NessieConflictException {
        String role = "test_user2";
        ContentsKey key = ContentsKey.of((String[])new String[]{"allowed", "some"});
        String branchName = "allowedBranchForTestUser2";
        this.createBranch(Branch.of((String)branchName, null), role, false);
        this.listAllReferences(branchName, false);
        Branch branch = this.retrieveBranch(branchName, role, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"add stuff")).operation((Operation)Operation.Put.of((ContentsKey)key, (Contents)IcebergTable.of((String)"foo", (String)"x", (String)"cid-foo"))).commit()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'UPDATE_ENTITY' is not allowed for role '%s' on content '%s'", role, key.toPathString()));
        this.readContent(branchName, key, role, true);
        Branch b = this.retrieveBranch(branchName, role, false);
        ImmutableOperations deleteOps = ImmutableOperations.builder().addOperations((Operation)ImmutableDelete.builder().key(key).build()).commitMeta(CommitMeta.fromMessage((String)"delete stuff")).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(b)).commitMeta(CommitMeta.fromMessage((String)"delete stuff")).operation((Operation)Operation.Delete.of((ContentsKey)key)).commit()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'DELETE_ENTITY' is not allowed for role '%s' on content '%s'", role, key.toPathString()));
        this.deleteBranch(branch, role, false);
    }

    private void listAllReferences(String branchName, boolean filteredOut) {
        if (filteredOut) {
            Assertions.assertThat((List)this.api().getAllReferences().get()).extracting(Reference::getName).doesNotContain((Object[])new String[]{branchName});
        } else {
            Assertions.assertThat((List)this.api().getAllReferences().get()).extracting(Reference::getName).contains((Object[])new String[]{branchName});
        }
    }

    private Branch retrieveBranch(String branchName, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api().getReference().refName(branchName).get()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'VIEW_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branchName));
            return null;
        }
        return (Branch)this.api().getReference().refName(branchName).get();
    }

    private void createBranch(Branch branch, String role, boolean shouldFail) throws NessieConflictException, NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api().createReference().sourceRefName("main").reference((Reference)branch).create()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'CREATE_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            this.api().createReference().sourceRefName("main").reference((Reference)branch).create();
        }
    }

    private void deleteBranch(Branch branch, String role, boolean shouldFail) throws NessieConflictException, NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(branch)).delete()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'DELETE_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            ((DeleteBranchBuilder)this.api().deleteBranch().branch(branch)).delete();
        }
    }

    private void readContent(String branchName, ContentsKey key, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Contents)((GetContentsBuilder)this.api().getContents().refName(branchName)).key(key).get().get(key)).unwrap(IcebergTable.class).get()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'READ_ENTITY_VALUE' is not allowed for role '%s' on content '%s'", role, key.toPathString()));
        } else {
            ((ObjectAssert)Assertions.assertThat((Object)((IcebergTable)((Contents)((GetContentsBuilder)this.api().getContents().refName(branchName)).key(key).get().get(key)).unwrap(IcebergTable.class).get())).isNotNull()).isInstanceOf(IcebergTable.class);
        }
    }

    private void getEntriesFor(String branchName, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)this.api().getEntries().refName(branchName)).get().getEntries()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'READ_ENTRIES' is not allowed for role '%s' on reference", role));
        } else {
            List tables = ((GetEntriesBuilder)this.api().getEntries().refName(branchName)).get().getEntries();
            Assertions.assertThat((List)tables).isNotEmpty();
        }
    }

    private void getCommitLog(String branchName, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.api().getCommitLog().refName(branchName)).get().getOperations()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'LIST_COMMIT_LOG' is not allowed for role '%s' on reference", role));
        } else {
            List commits = ((GetCommitLogBuilder)this.api().getCommitLog().refName(branchName)).get().getOperations();
            Assertions.assertThat((List)commits).isNotEmpty();
        }
    }

    private void addContent(Branch branch, Operation.Put put, String role, boolean shouldFail) throws NessieNotFoundException, NessieConflictException {
        CommitMultipleOperationsBuilder commitOp = ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).operation((Operation)put).commitMeta(CommitMeta.fromMessage((String)"add stuff"));
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)commitOp).commit()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'COMMIT_CHANGE_AGAINST_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            commitOp.commit();
        }
    }

    private void deleteContent(Branch branch, Operation.Delete delete, String role, boolean shouldFail) throws NessieConflictException, NessieNotFoundException {
        CommitMultipleOperationsBuilder commitOp = ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).operation((Operation)delete).commitMeta(CommitMeta.fromMessage((String)"delete stuff"));
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)commitOp).commit()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'COMMIT_CHANGE_AGAINST_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            commitOp.commit();
        }
    }
}

