/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.auth.BasicAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.server.BaseClientAuthTest;
import org.projectnessie.server.authn.AuthenticationEnabledProfile;

@QuarkusTest
@TestProfile(value=AuthenticationEnabledProfile.class)
class TestBasicAuthentication
extends BaseClientAuthTest {
    TestBasicAuthentication() {
    }

    @Test
    void testValidCredentials() {
        this.withClientCustomizer(c -> c.withAuthentication((NessieAuthentication)BasicAuthenticationProvider.create((String)"test_user", (String)"test_user")));
        Assertions.assertThat((List)this.api().getAllReferences().get()).isNotEmpty();
    }

    @Test
    void testValidAdminCredentials() {
        this.withClientCustomizer(c -> c.withAuthentication((NessieAuthentication)BasicAuthenticationProvider.create((String)"admin_user", (String)"test123")));
        Assertions.assertThat((List)this.api().getAllReferences().get()).isNotEmpty();
    }

    @Test
    void testInvalidCredentials() {
        this.withClientCustomizer(c -> c.withAuthentication((NessieAuthentication)BasicAuthenticationProvider.create((String)"test_user", (String)"bad_password")));
        Assertions.assertThatThrownBy(() -> this.api().getAllReferences().get()).isInstanceOfSatisfying(NessieNotAuthorizedException.class, e -> Assertions.assertThat((int)e.getError().getStatus()).isEqualTo(401));
    }
}

