/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.projectnessie.server.config.VersionStoreConfig;
import org.projectnessie.server.providers.StoreType;
import org.projectnessie.server.providers.VersionStoreFactory;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.mongodb.MongoDatabaseAdapterFactory;
import org.projectnessie.versioned.persist.mongodb.MongoDatabaseClient;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.store.PersistVersionStore;

@StoreType(value=VersionStoreConfig.VersionStoreType.MONGO)
@Dependent
public class MongoVersionStoreFactory
implements VersionStoreFactory {
    @Inject
    MongoDatabaseClient client;
    @Inject
    NonTransactionalDatabaseAdapterConfig config;

    @Override
    public <VALUE, METADATA, VALUE_TYPE extends Enum<VALUE_TYPE>> VersionStore<VALUE, METADATA, VALUE_TYPE> newStore(StoreWorker<VALUE, METADATA, VALUE_TYPE> worker, ServerConfig serverConfig) {
        DatabaseAdapter adapter = new MongoDatabaseAdapterFactory().newBuilder().withConfig((Object)this.config).withConnector((Object)this.client).build();
        adapter.initializeRepo(serverConfig.getDefaultBranch());
        return new PersistVersionStore(adapter, worker);
    }
}

