/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.oidc.server.OidcWiremockTestResource;
import io.smallrye.jwt.build.Jwt;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.auth.BearerAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.server.BaseClientAuthTest;
import org.projectnessie.server.authn.AuthenticationEnabledProfile;

@QuarkusTest
@QuarkusTestResource(value=OidcWiremockTestResource.class)
@TestProfile(value=Profile.class)
public class TestOpenIdAuthentication
extends BaseClientAuthTest {
    private String getJwtToken() {
        return Jwt.preferredUserName((String)"test_user").issuer("https://server.example.com").sign();
    }

    private String getExpiredJwtToken() {
        return Jwt.preferredUserName((String)"expired").issuer("https://server.example.com").expiresAt(0L).sign();
    }

    @Test
    void testValidJwt() {
        this.withClientCustomizer(b -> b.withAuthentication((NessieAuthentication)BearerAuthenticationProvider.create((String)this.getJwtToken())));
        Assertions.assertThat((List)this.api().getAllReferences().get()).isNotEmpty();
    }

    @Test
    void testExpiredToken() {
        this.withClientCustomizer(b -> b.withAuthentication((NessieAuthentication)BearerAuthenticationProvider.create((String)this.getExpiredJwtToken())));
        Assertions.assertThatThrownBy(() -> this.api().getAllReferences().get()).isInstanceOfSatisfying(NessieNotAuthorizedException.class, e -> Assertions.assertThat((int)e.getError().getStatus()).isEqualTo(401));
    }

    @Test
    void testAbsentToken() {
        Assertions.assertThatThrownBy(() -> this.api().getAllReferences().get()).isInstanceOfSatisfying(NessieNotAuthorizedException.class, e -> Assertions.assertThat((int)e.getError().getStatus()).isEqualTo(401));
    }

    public static class Profile
    implements QuarkusTestProfile {
        public Map<String, String> getConfigOverrides() {
            return ImmutableMap.builder().putAll(AuthenticationEnabledProfile.AUTH_CONFIG_OVERRIDES).put((Object)"quarkus.oidc.client-id", (Object)this.getClass().getName()).put((Object)"quarkus.oidc.auth-server-url", (Object)"${keycloak.url}/realms/quarkus/").put((Object)"smallrye.jwt.sign.key.location", (Object)"privateKey.jwk").build();
        }
    }
}

