/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import com.mongodb.client.MongoClient;
import io.quarkus.arc.Arc;
import io.quarkus.mongodb.runtime.MongoClients;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.projectnessie.server.config.VersionStoreConfig;
import org.projectnessie.server.providers.DatabaseAdapterBuilder;
import org.projectnessie.server.providers.StoreType;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.mongodb.MongoClientConfig;
import org.projectnessie.versioned.persist.mongodb.MongoDatabaseAdapterFactory;
import org.projectnessie.versioned.persist.mongodb.MongoDatabaseClient;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;

@StoreType(value=VersionStoreConfig.VersionStoreType.MONGO)
@Dependent
public class MongoDatabaseAdapterBuilder
implements DatabaseAdapterBuilder {
    @Inject
    @ConfigProperty(name="quarkus.mongodb.database")
    String databaseName;
    @Inject
    NonTransactionalDatabaseAdapterConfig config;

    @Override
    public DatabaseAdapter newDatabaseAdapter() {
        MongoClients mongoClients = (MongoClients)Arc.container().instance(MongoClients.class, new Annotation[0]).get();
        MongoClient mongoClient = mongoClients.createMongoClient("<default>");
        MongoDatabaseClient client = new MongoDatabaseClient();
        client.configure(MongoClientConfig.of((MongoClient)mongoClient).withDatabaseName(this.databaseName));
        client.initialize();
        return new MongoDatabaseAdapterFactory().newBuilder().withConfig((Object)this.config).withConnector((Object)client).build();
    }
}

