/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.rest.BaseExceptionMapper;

@Provider
public class ResteasyExceptionMapper
extends BaseExceptionMapper<ResteasyViolationException> {
    public ResteasyExceptionMapper() {
        this(null);
    }

    @Inject
    public ResteasyExceptionMapper(ServerConfig config) {
        super(config);
    }

    public Response toResponse(ResteasyViolationException exception) {
        Exception e = exception.getException();
        if (e == null) {
            boolean returnValueViolation = !exception.getReturnValueViolations().isEmpty();
            Response.Status st = returnValueViolation ? Response.Status.INTERNAL_SERVER_ERROR : Response.Status.BAD_REQUEST;
            return this.buildExceptionResponse(st.getStatusCode(), st.getReasonPhrase(), exception.getMessage(), (Exception)exception, false, b -> b.header("validation-exception", (Object)"true"));
        }
        return this.buildExceptionResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), this.unwrapException((Throwable)exception), (Exception)exception);
    }

    protected String unwrapException(Throwable t) {
        StringBuffer sb = new StringBuffer();
        this.doUnwrapException(sb, t);
        return sb.toString();
    }

    private void doUnwrapException(StringBuffer sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t.toString());
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            this.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }
}

