/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.authn;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.projectnessie.server.config.QuarkusNessieAuthenticationConfig;

@Alternative
@Priority(value=1)
@ApplicationScoped
public class NessieHttpAuthenticator
extends HttpAuthenticator {
    @Inject
    IdentityProviderManager identityProvider;
    private final boolean authEnabled;

    @Inject
    public NessieHttpAuthenticator(QuarkusNessieAuthenticationConfig config, Instance<HttpAuthenticationMechanism> instance, Instance<IdentityProvider<?>> providers) {
        super(instance, providers);
        this.authEnabled = config.enabled();
    }

    public Uni<SecurityIdentity> attemptAuthentication(RoutingContext context) {
        if (!this.authEnabled) {
            return this.anonymous();
        }
        return super.attemptAuthentication(context).onItem().transform(securityIdentity -> {
            if (securityIdentity == null) {
                throw new AuthenticationFailedException("Missing or unrecognized credentials");
            }
            return securityIdentity;
        });
    }

    private Uni<SecurityIdentity> anonymous() {
        return this.identityProvider.authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE);
    }
}

