/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.authz;

import com.google.common.collect.ImmutableMap;
import java.security.AccessControlException;
import java.util.Map;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.model.ContentKey;
import org.projectnessie.server.authz.CompiledAuthorizationRules;
import org.projectnessie.server.config.QuarkusNessieAuthorizationConfig;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.versioned.NamedRef;

@ApplicationScoped
public class CelAccessChecker
implements AccessChecker {
    private final QuarkusNessieAuthorizationConfig config;
    private final CompiledAuthorizationRules compiledRules;

    @Inject
    public CelAccessChecker(QuarkusNessieAuthorizationConfig config, CompiledAuthorizationRules compiledRules) {
        this.config = config;
        this.compiledRules = compiledRules;
    }

    public void canViewReference(AccessContext context, NamedRef ref) throws AccessControlException {
        this.canPerformOpOnReference(context, ref, AuthorizationRuleType.VIEW_REFERENCE);
    }

    public void canCreateReference(AccessContext context, NamedRef ref) throws AccessControlException {
        this.canPerformOpOnReference(context, ref, AuthorizationRuleType.CREATE_REFERENCE);
    }

    public void canAssignRefToHash(AccessContext context, NamedRef ref) throws AccessControlException {
        this.canViewReference(context, ref);
        this.canPerformOpOnReference(context, ref, AuthorizationRuleType.ASSIGN_REFERENCE_TO_HASH);
    }

    public void canDeleteReference(AccessContext context, NamedRef ref) throws AccessControlException {
        this.canViewReference(context, ref);
        this.canPerformOpOnReference(context, ref, AuthorizationRuleType.DELETE_REFERENCE);
    }

    public void canReadEntries(AccessContext context, NamedRef ref) throws AccessControlException {
        this.canViewReference(context, ref);
        this.canPerformOpOnReference(context, ref, AuthorizationRuleType.READ_ENTRIES);
    }

    public void canListCommitLog(AccessContext context, NamedRef ref) throws AccessControlException {
        this.canViewReference(context, ref);
        this.canPerformOpOnReference(context, ref, AuthorizationRuleType.LIST_COMMIT_LOG);
    }

    public void canCommitChangeAgainstReference(AccessContext context, NamedRef ref) throws AccessControlException {
        this.canViewReference(context, ref);
        this.canPerformOpOnReference(context, ref, AuthorizationRuleType.COMMIT_CHANGE_AGAINST_REFERENCE);
    }

    public void canReadEntityValue(AccessContext context, NamedRef ref, ContentKey key, String contentId) throws AccessControlException {
        this.canViewReference(context, ref);
        this.canPerformOpOnPath(context, ref, key, AuthorizationRuleType.READ_ENTITY_VALUE);
    }

    public void canUpdateEntity(AccessContext context, NamedRef ref, ContentKey key, String contentId) throws AccessControlException {
        this.canViewReference(context, ref);
        this.canPerformOpOnPath(context, ref, key, AuthorizationRuleType.UPDATE_ENTITY);
    }

    public void canDeleteEntity(AccessContext context, NamedRef ref, ContentKey key, String contentId) throws AccessControlException {
        this.canViewReference(context, ref);
        this.canPerformOpOnPath(context, ref, key, AuthorizationRuleType.DELETE_ENTITY);
    }

    private String getRoleName(AccessContext context) {
        return null != context.user() ? context.user().getName() : "";
    }

    private void canPerformOpOnReference(AccessContext context, NamedRef ref, AuthorizationRuleType type) {
        if (!this.config.enabled()) {
            return;
        }
        String roleName = this.getRoleName(context);
        ImmutableMap arguments = ImmutableMap.of((Object)"ref", (Object)ref.getName(), (Object)"role", (Object)roleName, (Object)"op", (Object)type.name());
        Supplier<String> errorMsgSupplier = () -> String.format("'%s' is not allowed for role '%s' on reference '%s'", new Object[]{type, roleName, ref.getName()});
        this.canPerformOp((Map<String, Object>)arguments, errorMsgSupplier);
    }

    private void canPerformOpOnPath(AccessContext context, NamedRef ref, ContentKey contentKey, AuthorizationRuleType type) {
        if (!this.config.enabled()) {
            return;
        }
        String roleName = this.getRoleName(context);
        ImmutableMap arguments = ImmutableMap.of((Object)"ref", (Object)ref.getName(), (Object)"path", (Object)contentKey.toPathString(), (Object)"role", (Object)roleName, (Object)"op", (Object)type.name());
        Supplier<String> errorMsgSupplier = () -> String.format("'%s' is not allowed for role '%s' on content '%s'", new Object[]{type, roleName, contentKey.toPathString()});
        this.canPerformOp((Map<String, Object>)arguments, errorMsgSupplier);
    }

    private void canPerformOp(Map<String, Object> arguments, Supplier<String> errorMessageSupplier) {
        boolean allowed = this.compiledRules.getRules().entrySet().stream().anyMatch(entry -> {
            try {
                return (Boolean)((Script)entry.getValue()).execute(Boolean.class, arguments);
            }
            catch (ScriptException e) {
                throw new RuntimeException(String.format("Failed to execute authorization rule with id '%s' and expression '%s' due to: %s", entry.getKey(), entry.getValue(), e.getMessage()), e);
            }
        });
        if (!allowed) {
            throw new AccessControlException(errorMessageSupplier.get());
        }
    }

    public static enum AuthorizationRuleType {
        VIEW_REFERENCE,
        CREATE_REFERENCE,
        DELETE_REFERENCE,
        LIST_COMMIT_LOG,
        READ_ENTRIES,
        ASSIGN_REFERENCE_TO_HASH,
        COMMIT_CHANGE_AGAINST_REFERENCE,
        READ_ENTITY_VALUE,
        UPDATE_ENTITY,
        DELETE_ENTITY;

    }
}

