/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.error;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.quarkus.test.junit.QuarkusTest;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.rest.NessieBackendThrottledException;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.server.error.OtherEntity;

@QuarkusTest
class TestNessieError {
    static String baseURI = "http://localhost:19121/api/v1/nessieErrorTest";
    private static HttpClient client;

    TestNessieError() {
    }

    @BeforeAll
    static void setup() {
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        client = HttpClient.builder().setBaseUri(URI.create(baseURI)).setObjectMapper(mapper).addResponseFilter((ResponseFilter)new NessieHttpResponseFilter(mapper)).build();
    }

    @Test
    void nullParameterQueryGet() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("nullParameterQueryGet").get()).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): nullParameterQueryGet.hash: must not be null");
    }

    @Test
    void nullParameterQueryPost() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("nullParameterQueryPost").post((Object)"")).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): nullParameterQueryPost.hash: must not be null");
    }

    @Test
    void emptyParameterQueryGet() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("emptyParameterQueryGet").get()).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): emptyParameterQueryGet.hash: must not be empty"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("emptyParameterQueryGet").queryParam("hash", "").get()).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): emptyParameterQueryGet.hash: must not be empty")});
    }

    @Test
    void blankParameterQueryGet() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("blankParameterQueryGet").get()).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): blankParameterQueryGet.hash: must not be blank"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("blankParameterQueryGet").queryParam("hash", "").get()).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): blankParameterQueryGet.hash: must not be blank"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("blankParameterQueryGet").queryParam("hash", "   ").get()).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): blankParameterQueryGet.hash: must not be blank")});
    }

    @Test
    void entityValueViolation() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("basicEntity").put((Object)"not really valid json")).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Unrecognized token 'not': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')\n"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("basicEntity").put((Object)"{}")).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Missing required creator property 'value' (index 0)\n"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("basicEntity").put((Object)"{\"value\":null}")).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): basicEntity.entity.value: must not be null"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("basicEntity").put((Object)"{\"value\":1.234}")).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): basicEntity.entity.value: must be greater than or equal to 3")});
    }

    @Test
    void brokenEntitySerialization() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> client.newRequest().path("basicEntity").put((Object)new OtherEntity("bar")))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Missing required creator property 'value' (index 0)\n");
    }

    @Test
    void nessieNotFoundException() {
        NessieNotFoundException ex = (NessieNotFoundException)org.junit.jupiter.api.Assertions.assertThrows(NessieNotFoundException.class, () -> this.unwrap(() -> client.newRequest().path("nessieNotFound").get()));
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((Object)"not-there-message", (Object)ex.getMessage()), () -> org.junit.jupiter.api.Assertions.assertNull((Object)ex.getServerStackTrace()), () -> org.junit.jupiter.api.Assertions.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)ex.getStatus())});
    }

    @Test
    void nonConstraintValidationExceptions() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> client.newRequest().path("constraintDefinitionException").get())).isInstanceOf(NessieInternalServerException.class)).hasMessage("Internal Server Error (HTTP/500): javax.validation.ConstraintDefinitionException: meep"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> client.newRequest().path("constraintDeclarationException").get())).isInstanceOf(NessieInternalServerException.class)).hasMessage("Internal Server Error (HTTP/500): javax.validation.ConstraintDeclarationException: meep"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> client.newRequest().path("groupDefinitionException").get())).isInstanceOf(NessieInternalServerException.class)).hasMessage("Internal Server Error (HTTP/500): javax.validation.GroupDefinitionException: meep")});
    }

    @Test
    void unhandledRuntimeExceptionInStore() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("unhandledExceptionInTvsStore/runtime").get()).isInstanceOf(NessieInternalServerException.class)).hasMessage("Internal Server Error (HTTP/500): java.lang.RuntimeException: Store.getValues-throwing");
    }

    @Test
    void backendThrottledExceptionInStore() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.newRequest().path("unhandledExceptionInTvsStore/throttle").get()).isInstanceOf(NessieBackendThrottledException.class)).hasMessage("Too Many Requests (HTTP/429): Backend store refused to process the request: org.projectnessie.versioned.BackendLimitExceededException: Store.getValues-throttled");
    }

    void unwrap(Executable exec) throws Throwable {
        try {
            exec.execute();
        }
        catch (Throwable targetException) {
            if (targetException instanceof HttpClientException && (targetException.getCause() instanceof NessieNotFoundException || targetException.getCause() instanceof NessieConflictException)) {
                throw targetException.getCause();
            }
            throw targetException;
        }
    }
}

