/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server.config;

import com.dremio.nessie.server.config.converters.BackendType;
import com.dremio.nessie.server.config.converters.JGitStoreType;
import com.dremio.nessie.server.config.converters.VersionStoreType;
import com.dremio.nessie.services.config.ServerConfig;
import io.quarkus.arc.config.ConfigProperties;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class ApplicationConfig {
    private final BackendsConfig backendsConfig;
    private final VersionStoreConfig versionStoreConfig;
    private final VersionStoreJGitConfig versionStoreJGitConfig;
    private final VersionStoreDynamoConfig versionStoreDynamoConfig;

    @Inject
    public ApplicationConfig(BackendsConfig backendsConfig, VersionStoreConfig versionStoreConfig, VersionStoreJGitConfig versionStoreJGitConfig, VersionStoreDynamoConfig versionStoreDynamoConfig) {
        this.backendsConfig = backendsConfig;
        this.versionStoreConfig = versionStoreConfig;
        this.versionStoreJGitConfig = versionStoreJGitConfig;
        this.versionStoreDynamoConfig = versionStoreDynamoConfig;
    }

    public BackendsConfig getBackendsConfig() {
        return this.backendsConfig;
    }

    public VersionStoreConfig getVersionStoreConfig() {
        return this.versionStoreConfig;
    }

    public VersionStoreJGitConfig getVersionStoreJGitConfig() {
        return this.versionStoreJGitConfig;
    }

    public VersionStoreDynamoConfig getVersionStoreDynamoConfig() {
        return this.versionStoreDynamoConfig;
    }

    @ConfigProperties(prefix="nessie.version.store.dynamo")
    public static interface VersionStoreDynamoConfig {
        @ConfigProperty(name="initialize", defaultValue="false")
        public boolean isDynamoInitialize();

        @ConfigProperty(name="refTableName", defaultValue="nessie_refs")
        public String getRefTableName();

        @ConfigProperty(name="treeTableName", defaultValue="nessie_objects")
        public String getTreeTableName();

        @ConfigProperty(name="valueTableName", defaultValue="nessie_objects")
        public String getValueTableName();
    }

    @ConfigProperties(prefix="nessie.version.store.jgit")
    public static interface VersionStoreJGitConfig {
        @ConfigProperty(name="type", defaultValue="INMEMORY")
        public JGitStoreType getJgitStoreType();

        @ConfigProperty(name="directory")
        public Optional<String> getJgitDirectory();
    }

    @ConfigProperties(prefix="nessie.version.store")
    public static interface VersionStoreConfig {
        @ConfigProperty(name="type", defaultValue="INMEMORY")
        public VersionStoreType getVersionStoreType();
    }

    @ConfigProperties(prefix="nessie.backends")
    public static interface BackendsConfig {
        @ConfigProperty(name="type", defaultValue="INMEMORY")
        public BackendType getBackendType();
    }

    @ConfigProperties(prefix="nessie.server")
    public static interface ServerConfigImpl
    extends ServerConfig {
        @ConfigProperty(name="default-branch", defaultValue="main")
        public String getDefaultBranch();

        @ConfigProperty(name="send-stacktrace-to-client", defaultValue="main")
        public boolean shouldSendstackTraceToAPIClient();
    }
}

