/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server.providers;

import com.dremio.nessie.backend.Backend;
import com.dremio.nessie.backend.dynamodb.DynamoDbBackend;
import com.dremio.nessie.backend.simple.InMemory;
import com.dremio.nessie.server.config.ApplicationConfig;
import com.dremio.nessie.server.config.converters.BackendType;
import com.dremio.nessie.server.config.converters.JGitStoreType;
import java.util.Optional;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class BackendProducer {
    private final ApplicationConfig config;
    @ConfigProperty(name="quarkus.dynamodb.aws.region")
    String region;
    @ConfigProperty(name="quarkus.dynamodb.endpoint-override")
    Optional<String> endpoint;

    @Inject
    public BackendProducer(ApplicationConfig config) {
        this.config = config;
    }

    @Singleton
    @Produces
    public Backend producer() {
        if (!this.config.getVersionStoreJGitConfig().getJgitStoreType().equals((Object)JGitStoreType.DYNAMO)) {
            return null;
        }
        if (this.config.getBackendsConfig().getBackendType().equals((Object)BackendType.INMEMORY)) {
            return new InMemory.BackendFactory().create();
        }
        return new DynamoDbBackend.BackendFactory().create(this.region, (String)this.endpoint.orElse(null));
    }
}

