/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server.providers;

import com.dremio.nessie.jgit.ObjectTypes;
import com.dremio.nessie.model.CommitMeta;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.DeltaLakeTable;
import com.dremio.nessie.model.HiveDatabase;
import com.dremio.nessie.model.HiveTable;
import com.dremio.nessie.model.IcebergTable;
import com.dremio.nessie.model.ImmutableCommitMeta;
import com.dremio.nessie.model.ImmutableDeltaLakeTable;
import com.dremio.nessie.model.ImmutableHiveDatabase;
import com.dremio.nessie.model.ImmutableHiveTable;
import com.dremio.nessie.model.ImmutableIcebergTable;
import com.dremio.nessie.model.ImmutableSqlView;
import com.dremio.nessie.model.SqlView;
import com.dremio.nessie.versioned.Serializer;
import com.dremio.nessie.versioned.StoreWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;

@Singleton
public class TableCommitMetaStoreWorker
implements StoreWorker<Contents, CommitMeta> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Serializer<Contents> tableSerializer = this.serializer();
    private final Serializer<CommitMeta> metaSerializer = this.metadataSerializer();

    private Serializer<Contents> serializer() {
        return new Serializer<Contents>(){

            public ByteString toBytes(Contents value) {
                ObjectTypes.PContents.Builder builder = ObjectTypes.PContents.newBuilder();
                if (value instanceof IcebergTable) {
                    builder.setIcebergTable(ObjectTypes.PIcebergTable.newBuilder().setMetadataLocation(((IcebergTable)value).getMetadataLocation()));
                } else if (value instanceof DeltaLakeTable) {
                    ObjectTypes.PDeltaLakeTable.Builder table = ObjectTypes.PDeltaLakeTable.newBuilder().addAllMetadataLocationHistory(((DeltaLakeTable)value).getMetadataLocationHistory()).addAllCheckpointLocationHistory(((DeltaLakeTable)value).getCheckpointLocationHistory());
                    String lastCheckpoint = ((DeltaLakeTable)value).getLastCheckpoint();
                    if (lastCheckpoint != null) {
                        table.setLastCheckpoint(lastCheckpoint);
                    }
                    builder.setDeltaLakeTable(table);
                } else if (value instanceof HiveTable) {
                    HiveTable ht = (HiveTable)value;
                    builder.setHiveTable(ObjectTypes.PHiveTable.newBuilder().setTable(UnsafeByteOperations.unsafeWrap((byte[])ht.getTableDefinition())).addAllPartition(ht.getPartitions().stream().map(UnsafeByteOperations::unsafeWrap).collect(Collectors.toList())));
                } else if (value instanceof HiveDatabase) {
                    builder.setHiveDatabase(ObjectTypes.PHiveDatabase.newBuilder().setDatabase(UnsafeByteOperations.unsafeWrap((byte[])((HiveDatabase)value).getDatabaseDefinition())));
                } else if (value instanceof SqlView) {
                    SqlView view = (SqlView)value;
                    builder.setSqlView(ObjectTypes.PSqlView.newBuilder().setDialect(view.getDialect().name()).setSqlText(view.getSqlText()));
                } else {
                    throw new IllegalArgumentException("Unknown type" + value);
                }
                return builder.build().toByteString();
            }

            public Contents fromBytes(ByteString bytes) {
                ObjectTypes.PContents contents;
                try {
                    contents = ObjectTypes.PContents.parseFrom(bytes);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Failure parsing data", e);
                }
                switch (contents.getObjectTypeCase()) {
                    case DELTA_LAKE_TABLE: {
                        ImmutableDeltaLakeTable.Builder builder = ImmutableDeltaLakeTable.builder().addAllMetadataLocationHistory((Iterable)contents.getDeltaLakeTable().getMetadataLocationHistoryList()).addAllCheckpointLocationHistory((Iterable)contents.getDeltaLakeTable().getCheckpointLocationHistoryList());
                        if (contents.getDeltaLakeTable().getLastCheckpoint() != null) {
                            builder.lastCheckpoint(contents.getDeltaLakeTable().getLastCheckpoint());
                        }
                        return builder.build();
                    }
                    case HIVE_DATABASE: {
                        return ImmutableHiveDatabase.builder().databaseDefinition(contents.getHiveDatabase().getDatabase().toByteArray()).build();
                    }
                    case HIVE_TABLE: {
                        return ImmutableHiveTable.builder().addAllPartitions((Iterable)contents.getHiveTable().getPartitionList().stream().map(ByteString::toByteArray).collect(Collectors.toList())).tableDefinition(contents.getHiveTable().getTable().toByteArray()).build();
                    }
                    case ICEBERG_TABLE: {
                        return ImmutableIcebergTable.builder().metadataLocation(contents.getIcebergTable().getMetadataLocation()).build();
                    }
                    case SQL_VIEW: {
                        ObjectTypes.PSqlView view = contents.getSqlView();
                        return ImmutableSqlView.builder().dialect(SqlView.Dialect.valueOf((String)view.getDialect())).sqlText(view.getSqlText()).build();
                    }
                }
                throw new IllegalArgumentException("Unknown type" + (Object)((Object)contents.getObjectTypeCase()));
            }
        };
    }

    private Serializer<CommitMeta> metadataSerializer() {
        return new Serializer<CommitMeta>(){

            public ByteString toBytes(CommitMeta value) {
                try {
                    return ByteString.copyFrom((byte[])MAPPER.writeValueAsBytes((Object)value));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(String.format("Couldn't serialize commit meta %s", value), e);
                }
            }

            public CommitMeta fromBytes(ByteString bytes) {
                try {
                    return (CommitMeta)MAPPER.readValue(bytes.toByteArray(), CommitMeta.class);
                }
                catch (IOException e) {
                    return ImmutableCommitMeta.builder().message("unknown").commiter("unknown").email("unknown").hash("unknown").build();
                }
            }
        };
    }

    public Serializer<Contents> getValueSerializer() {
        return this.tableSerializer;
    }

    public Serializer<CommitMeta> getMetadataSerializer() {
        return this.metaSerializer;
    }

    public Stream<StoreWorker.AssetKey> getAssetKeys(Contents table) {
        throw new UnsupportedOperationException("No serialization available for AssetKey");
    }

    public CompletableFuture<Void> deleteAsset(StoreWorker.AssetKey key) {
        throw new UnsupportedOperationException("No serialization available for AssetKey");
    }
}

