/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server;

import com.dremio.nessie.api.ContentsApi;
import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.IcebergTable;
import com.dremio.nessie.model.MultiGetContentsRequest;
import com.dremio.nessie.model.MultiGetContentsResponse;
import com.dremio.nessie.model.Reference;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
class TestRest {
    private NessieClient client;
    private TreeApi tree;
    private ContentsApi contents;

    TestRest() {
    }

    @BeforeEach
    void init() throws NessieNotFoundException, NessieConflictException {
        String path = "http://localhost:19121/api/v1";
        this.client = new NessieClient(NessieClient.AuthType.NONE, path, null, null);
        this.tree = this.client.getTreeApi();
        this.contents = this.client.getContentsApi();
    }

    @Test
    void multiget() throws NessieNotFoundException, NessieConflictException {
        String branch = "foo";
        this.tree.createReference((Reference)Branch.of((String)"foo", null));
        Reference r = this.tree.getReferenceByName("foo");
        ContentsKey a = ContentsKey.of((String[])new String[]{"a"});
        ContentsKey b = ContentsKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        IcebergTable tb = IcebergTable.of((String)"path2");
        this.contents.setContents(a, "foo", r.getHash(), "commit 1", (Contents)ta);
        this.contents.setContents(b, "foo", r.getHash(), "commit 2", (Contents)tb);
        List keys = this.contents.getMultipleContents("foo", MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{a, b, ContentsKey.of((String[])new String[]{"noexist"})})).getContents();
        List<MultiGetContentsResponse.ContentsWithKey> expected = Arrays.asList(MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)a, (Contents)ta), MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)b, (Contents)tb));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.containsInAnyOrder((Object[])expected.toArray()));
        this.tree.deleteBranch("foo", this.tree.getReferenceByName("foo").getHash());
    }

    @Test
    void checkSpecialCharacterRoundTrip() throws NessieNotFoundException, NessieConflictException {
        String branch = "specialchar";
        this.tree.createReference((Reference)Branch.of((String)"specialchar", null));
        Reference r = this.tree.getReferenceByName("specialchar");
        ContentsKey k = ContentsKey.of((String[])new String[]{"a.b", "c.d"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        this.contents.setContents(k, "specialchar", r.getHash(), "commit 1", (Contents)ta);
        Assertions.assertEquals((Object)MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)k, (Contents)ta), this.contents.getMultipleContents("specialchar", MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{k})).getContents().get(0));
        Assertions.assertEquals((Object)ta, (Object)this.contents.getContents(k, "specialchar"));
        this.tree.deleteBranch("specialchar", this.tree.getReferenceByName("specialchar").getHash());
    }

    @Test
    void checkServerErrorPropagation() throws NessieNotFoundException, NessieConflictException {
        String branch = "bar";
        this.tree.createReference((Reference)Branch.of((String)"bar", null));
        NessieConflictException e = (NessieConflictException)Assertions.assertThrows(NessieConflictException.class, () -> this.tree.createReference((Reference)Branch.of((String)"bar", null)));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"already exists"));
    }
}

