/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server.providers;

import com.dremio.nessie.error.BaseNessieClientServerException;
import com.dremio.nessie.error.NessieError;
import com.dremio.nessie.services.config.ServerConfig;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class NessieExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieExceptionMapper.class);
    @Inject
    ServerConfig serverConfig;

    public Response toResponse(Exception exception) {
        if (exception instanceof WebApplicationException) {
            Response.Status status = Response.Status.fromStatusCode((int)((WebApplicationException)exception).getResponse().getStatus());
            return this.exception(status, exception.getMessage(), exception);
        }
        if (exception instanceof BaseNessieClientServerException) {
            LOGGER.debug("Exception on server with appropriate error sent to client.", (Throwable)exception);
            return this.exception(((BaseNessieClientServerException)exception).getStatus(), exception.getMessage(), exception);
        }
        if (exception instanceof JsonParseException) {
            return this.exception(Response.Status.BAD_REQUEST, exception.getMessage(), exception);
        }
        if (exception instanceof JsonMappingException) {
            return this.exception(Response.Status.BAD_REQUEST, exception.getMessage(), exception);
        }
        return this.exception(Response.Status.INTERNAL_SERVER_ERROR, exception.getMessage(), exception);
    }

    private Response exception(Response.Status status, String message, Exception e) {
        String stack = this.serverConfig.shouldSendstackTraceToAPIClient() ? Throwables.getStackTraceAsString((Throwable)e) : null;
        NessieError error = new NessieError(message, status, stack);
        LOGGER.debug("Failure on server, propagated to client. Status: {} {}, Message: {}.", new Object[]{status.getStatusCode(), status.getReasonPhrase(), message, e});
        return Response.status((Response.Status)status).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

