/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.profiles;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;

public class RocksTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private Path rocksDir;

    public Map<String, String> start() {
        try {
            this.rocksDir = Files.createTempDirectory("test-quarkus-rocks", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ImmutableMap.of((Object)"nessie.version.store.rocks.db-path", (Object)this.rocksDir.toAbsolutePath().toString());
    }

    public void stop() {
        try {
            RocksTestResourceLifecycleManager.deleteTempDir(this.rocksDir);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void deleteTempDir(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            return;
        }
        final ArrayList failures = new ArrayList();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                return this.tryDelete(file);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return this.tryDelete(dir);
            }

            private FileVisitResult tryDelete(Path path) {
                try {
                    Files.delete(path);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    failures.add(e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (!failures.isEmpty()) {
            IOException e = new IOException("Could not delete temp-directory " + dir);
            failures.forEach(e::addSuppressed);
            throw e;
        }
    }
}

