/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import io.quarkus.runtime.Startup;
import java.io.IOError;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.server.config.VersionStoreConfig;
import org.projectnessie.server.providers.DatabaseAdapterBuilder;
import org.projectnessie.server.providers.StoreType;
import org.projectnessie.server.store.TableCommitMetaStoreWorker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.MetricsVersionStore;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.TracingVersionStore;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.persist.adapter.ContentVariantSupplier;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.spi.TracingDatabaseAdapter;
import org.projectnessie.versioned.persist.store.GenericContentVariantSupplier;
import org.projectnessie.versioned.persist.store.PersistVersionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ConfigurableVersionStoreFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableVersionStoreFactory.class);
    private final Instance<DatabaseAdapterBuilder> databaseAdapterBuilder;
    private final VersionStoreConfig storeConfig;
    private final ServerConfig serverConfig;

    @Inject
    public ConfigurableVersionStoreFactory(@Any Instance<DatabaseAdapterBuilder> databaseAdapterBuilder, VersionStoreConfig storeConfig, ServerConfig serverConfig) {
        this.databaseAdapterBuilder = databaseAdapterBuilder;
        this.storeConfig = storeConfig;
        this.serverConfig = serverConfig;
    }

    @Produces
    @Singleton
    @Startup
    public VersionStore<Content, CommitMeta, Content.Type> getVersionStore() {
        VersionStoreConfig.VersionStoreType versionStoreType = this.storeConfig.getVersionStoreType();
        try {
            LOGGER.info("Using {} Version store", (Object)versionStoreType);
            TableCommitMetaStoreWorker storeWorker = new TableCommitMetaStoreWorker();
            DatabaseAdapter databaseAdapter = ((DatabaseAdapterBuilder)this.databaseAdapterBuilder.select(new Annotation[]{new StoreType.Literal(versionStoreType)}).get()).newDatabaseAdapter((ContentVariantSupplier)new GenericContentVariantSupplier((StoreWorker)storeWorker));
            databaseAdapter.initializeRepo(this.serverConfig.getDefaultBranch());
            if (this.storeConfig.isTracingEnabled()) {
                databaseAdapter = new TracingDatabaseAdapter(databaseAdapter);
            }
            PersistVersionStore versionStore = new PersistVersionStore(databaseAdapter, (StoreWorker)storeWorker);
            if (this.storeConfig.isTracingEnabled()) {
                versionStore = new TracingVersionStore((VersionStore)versionStore);
            }
            if (this.storeConfig.isMetricsEnabled()) {
                versionStore = new MetricsVersionStore((VersionStore)versionStore);
            }
            return versionStore;
        }
        catch (IOError | RuntimeException e) {
            LOGGER.error("Failed to configure/start {} version store", (Object)versionStoreType, (Object)e);
            throw e;
        }
    }
}

