/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.projectnessie.server.config.VersionStoreConfig;
import org.projectnessie.server.providers.DatabaseAdapterBuilder;
import org.projectnessie.server.providers.StoreType;
import org.projectnessie.versioned.persist.adapter.ContentVariantSupplier;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.dynamodb.DynamoClientConfig;
import org.projectnessie.versioned.persist.dynamodb.DynamoDatabaseAdapterFactory;
import org.projectnessie.versioned.persist.dynamodb.DynamoDatabaseClient;
import org.projectnessie.versioned.persist.dynamodb.ProvidedDynamoClientConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@StoreType(value=VersionStoreConfig.VersionStoreType.DYNAMO)
@Dependent
public class DynamoDatabaseAdapterBuilder
implements DatabaseAdapterBuilder {
    @Inject
    DynamoDbClient dynamoConfig;
    @Inject
    NonTransactionalDatabaseAdapterConfig config;

    @Override
    public DatabaseAdapter newDatabaseAdapter(ContentVariantSupplier contentVariantSupplier) {
        DynamoDatabaseClient client = new DynamoDatabaseClient();
        client.configure((DynamoClientConfig)ProvidedDynamoClientConfig.of((DynamoDbClient)this.dynamoConfig));
        client.initialize();
        return new DynamoDatabaseAdapterFactory().newBuilder().withConfig((Object)this.config).withConnector((Object)client).build(contentVariantSupplier);
    }
}

