/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.auth.BasicAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.server.BaseClientAuthTest;
import org.projectnessie.server.authn.AuthenticationEnabledProfile;

@QuarkusTest
@TestProfile(value=Profile.class)
class TestBasicAuthentication
extends BaseClientAuthTest {
    TestBasicAuthentication() {
    }

    @Test
    void testValidCredentials() {
        this.withClientCustomizer(c -> c.withAuthentication((NessieAuthentication)BasicAuthenticationProvider.create((String)"test_user", (String)"test_user")));
        Assertions.assertThat((List)this.api().getAllReferences().get().getReferences()).isNotEmpty();
    }

    @Test
    void testValidAdminCredentials() {
        this.withClientCustomizer(c -> c.withAuthentication((NessieAuthentication)BasicAuthenticationProvider.create((String)"admin_user", (String)"test123")));
        Assertions.assertThat((List)this.api().getAllReferences().get().getReferences()).isNotEmpty();
    }

    @Test
    void testInvalidCredentials() {
        this.withClientCustomizer(c -> c.withAuthentication((NessieAuthentication)BasicAuthenticationProvider.create((String)"test_user", (String)"bad_password")));
        Assertions.assertThatThrownBy(() -> this.api().getAllReferences().get()).isInstanceOfSatisfying(NessieNotAuthorizedException.class, e -> Assertions.assertThat((int)e.getError().getStatus()).isEqualTo(401));
    }

    public static class Profile
    extends AuthenticationEnabledProfile {
        @Override
        public Map<String, String> getConfigOverrides() {
            return ImmutableMap.builder().putAll(super.getConfigOverrides()).put((Object)"quarkus.http.auth.basic", (Object)"true").build();
        }
    }
}

