/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.security.TestSecurity;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieForbiddenException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.server.BaseClientAuthTest;
import org.projectnessie.server.authz.NessieAuthorizationTestProfile;

@QuarkusTest
@TestProfile(value=NessieAuthorizationTestProfile.class)
class TestAuthorizationRules
extends BaseClientAuthTest {
    TestAuthorizationRules() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @TestSecurity(user="test_user")
    void testAllOpsWithTestUser(boolean shouldFail) throws BaseNessieClientServerException {
        this.testAllOps("allowedBranchForTestUser", "test_user", shouldFail);
    }

    @Test
    @TestSecurity(user="admin_user")
    void testAdminUserIsAllowedEverything() throws BaseNessieClientServerException {
        this.testAllOps("testAdminUserIsAllowedAllBranch", "admin_user", false);
    }

    private void testAllOps(String branchName, String role, boolean shouldFail) throws BaseNessieClientServerException {
        boolean isAdmin = role.equals("admin_user");
        ContentKey key = ContentKey.of((String[])new String[]{"allowed", "x"});
        if (shouldFail) {
            branchName = "disallowedBranchForTestUser";
            key = ContentKey.of((String[])new String[]{"disallowed", "x"});
        }
        this.createBranch(Branch.of((String)branchName, null), role, shouldFail);
        Branch branchWithInvalidHash = Branch.of((String)branchName, (String)"1234567890123456");
        Branch branch = shouldFail ? branchWithInvalidHash : this.retrieveBranch(branchName, role, shouldFail);
        this.listAllReferences(branchName, shouldFail);
        String cid = "cid-foo-" + UUID.randomUUID();
        this.addContent(branch, Operation.Put.of((ContentKey)key, (Content)IcebergTable.of((String)"foo", (long)42L, (int)42, (int)42, (int)42, (String)cid)), role, shouldFail);
        if (!shouldFail) {
            this.getCommitLog(branchName, role, shouldFail);
            this.getEntriesFor(branchName, role, shouldFail);
            this.readContent(branchName, key, role, shouldFail);
        }
        branch = shouldFail ? branchWithInvalidHash : this.retrieveBranch(branchName, role, shouldFail);
        this.deleteContent(branch, Operation.Delete.of((ContentKey)key), role, shouldFail);
        branch = shouldFail ? branchWithInvalidHash : this.retrieveBranch(branchName, role, shouldFail);
        this.deleteBranch(branch, role, shouldFail);
        this.getRefLog(role, !isAdmin);
        Branch defaultBranch = this.api().getDefaultBranch();
        this.deleteBranch(defaultBranch, role, !isAdmin);
        if (isAdmin) {
            this.api().createReference().reference((Reference)Branch.of((String)defaultBranch.getName(), null)).create();
        }
    }

    @Test
    @TestSecurity(user="test_user2")
    void testCanCommitButNotUpdateOrDeleteEntity() throws BaseNessieClientServerException {
        String role = "test_user2";
        ContentKey key = ContentKey.of((String[])new String[]{"allowed", "some"});
        String branchName = "allowedBranchForTestUser2";
        this.createBranch(Branch.of((String)branchName, null), role, false);
        this.listAllReferences(branchName, false);
        Branch branch = this.retrieveBranch(branchName, role, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"add stuff")).operation((Operation)Operation.Put.of((ContentKey)key, (Content)IcebergTable.of((String)"foo", (long)42L, (int)42, (int)42, (int)42, (String)"cid-foo"))).commit()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'UPDATE_ENTITY' is not allowed for role '%s' on content '%s'", role, key.toPathString()));
        this.readContent(branchName, key, role, true);
        Branch b = this.retrieveBranch(branchName, role, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(b)).commitMeta(CommitMeta.fromMessage((String)"delete stuff")).operation((Operation)Operation.Delete.of((ContentKey)key)).commit()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'DELETE_ENTITY' is not allowed for role '%s' on content '%s'", role, key.toPathString()));
        this.deleteBranch(branch, role, false);
    }

    @Test
    @TestSecurity(user="admin_user")
    void testCanReadTargetBranchDuringAssign() throws BaseNessieClientServerException {
        String role = "admin_user";
        String branchName = "adminCanReadWhenAssigning";
        String targetBranchName = "targetBranchForAssign";
        this.createBranch(Branch.of((String)branchName, null), role, false);
        Branch branch = this.retrieveBranch(branchName, role, false);
        this.createBranch(Branch.of((String)targetBranchName, null), role, false);
        Branch targetBranch = this.retrieveBranch(targetBranchName, role, false);
        this.addContent(targetBranch, Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"allowed", "x"}), (Content)IcebergTable.of((String)"foo", (long)42L, (int)42, (int)42, (int)42, (String)UUID.randomUUID().toString())), role, false);
        targetBranch = this.retrieveBranch(targetBranchName, role, false);
        ((AssignBranchBuilder)this.api().assignBranch().branch(branch)).assignTo((Reference)targetBranch).assign();
        branch = this.retrieveBranch(branchName, role, false);
        Assertions.assertThat((String)branch.getHash()).isEqualTo(targetBranch.getHash());
    }

    @Test
    @TestSecurity(user="admin_user")
    void testCanReadTargetBranchDuringMerge() throws BaseNessieClientServerException {
        String role = "admin_user";
        String branchName = "adminCanReadWhenMerging";
        String targetBranchName = "targetBranchForMerge";
        this.createBranch(Branch.of((String)branchName, null), role, false);
        Branch branch = this.retrieveBranch(branchName, role, false);
        this.createBranch(Branch.of((String)targetBranchName, null), role, false);
        Branch targetBranch = this.retrieveBranch(targetBranchName, role, false);
        this.addContent(branch, Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"allowed", "x"}), (Content)IcebergTable.of((String)"foo", (long)42L, (int)42, (int)42, (int)42, (String)UUID.randomUUID().toString())), role, false);
        branch = this.retrieveBranch(branchName, role, false);
        ((MergeReferenceBuilder)this.api().mergeRefIntoBranch().fromRef((Reference)branch).branch(targetBranch)).merge();
        targetBranch = this.retrieveBranch(targetBranch.getName(), role, false);
        Assertions.assertThat((List)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)targetBranch)).get().getLogEntries()).isNotEmpty();
    }

    @Test
    @TestSecurity(user="admin_user")
    void testCanReadTargetBranchDuringTransplant() throws BaseNessieClientServerException {
        String role = "admin_user";
        String branchName = "adminCanReadWhenTransplanting";
        String targetBranchName = "targetBranchForTransplant";
        this.createBranch(Branch.of((String)branchName, null), role, false);
        Branch branch = this.retrieveBranch(branchName, role, false);
        this.createBranch(Branch.of((String)targetBranchName, null), role, false);
        Branch targetBranch = this.retrieveBranch(targetBranchName, role, false);
        this.addContent(branch, Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"allowed", "x"}), (Content)IcebergTable.of((String)"foo", (long)42L, (int)42, (int)42, (int)42, (String)UUID.randomUUID().toString())), role, false);
        branch = this.retrieveBranch(branchName, role, false);
        ((TransplantCommitsBuilder)this.api().transplantCommitsIntoBranch().fromRefName(branch.getName()).hashesToTransplant(((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)branch)).get().getLogEntries().stream().map(e -> e.getCommitMeta().getHash()).collect(Collectors.toList())).branch(targetBranch)).transplant();
        targetBranch = this.retrieveBranch(targetBranch.getName(), role, false);
        Assertions.assertThat((List)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)targetBranch)).get().getLogEntries()).isNotEmpty();
    }

    @Test
    @TestSecurity(user="user1")
    void testCannotReadTargetBranch() throws BaseNessieClientServerException {
        String role = "user1";
        String branchName = "allowedBranchForUser1";
        this.createBranch(Branch.of((String)branchName, null), role, false);
        String disallowedBranch = "disallowedBranchForUser1";
        this.createBranch(Branch.of((String)disallowedBranch, null), role, false);
        Branch branch = this.retrieveBranch(branchName, role, false);
        String errorMessage = String.format("'VIEW_REFERENCE' is not allowed for role '%s' on reference '%s'", role, disallowedBranch);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AssignBranchBuilder)this.api().assignBranch().branch(branch)).assignTo((Reference)Branch.of((String)disallowedBranch, (String)branch.getHash())).assign()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(errorMessage);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)this.api().mergeRefIntoBranch().fromRef((Reference)branch).branch(Branch.of((String)disallowedBranch, (String)branch.getHash()))).merge()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(errorMessage);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TransplantCommitsBuilder)this.api().transplantCommitsIntoBranch().hashesToTransplant(Arrays.asList(branch.getHash())).fromRefName(branch.getName()).branch(Branch.of((String)disallowedBranch, (String)branch.getHash()))).transplant()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(errorMessage);
        this.deleteBranch(branch, role, false);
    }

    private void listAllReferences(String branchName, boolean filteredOut) {
        if (filteredOut) {
            Assertions.assertThat((List)this.api().getAllReferences().get().getReferences()).extracting(Reference::getName).doesNotContain((Object[])new String[]{branchName});
        } else {
            Assertions.assertThat((List)this.api().getAllReferences().get().getReferences()).extracting(Reference::getName).contains((Object[])new String[]{branchName});
        }
    }

    private Branch retrieveBranch(String branchName, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api().getReference().refName(branchName).get()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'VIEW_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branchName));
            return null;
        }
        return (Branch)this.api().getReference().refName(branchName).get();
    }

    private void createBranch(Branch branch, String role, boolean shouldFail) throws BaseNessieClientServerException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api().createReference().sourceRefName("main").reference((Reference)branch).create()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'CREATE_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            this.api().createReference().sourceRefName("main").reference((Reference)branch).create();
        }
    }

    private void deleteBranch(Branch branch, String role, boolean shouldFail) throws BaseNessieClientServerException {
        if (shouldFail) {
            Assertions.assertThat((String)role).isNotEqualTo((Object)"admin_user");
            String expectedErrorMsg = String.format("'DELETE_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName());
            if (this.api().getDefaultBranch().equals(branch)) {
                expectedErrorMsg = String.format("'DELETE_DEFAULT_BRANCH' is not allowed for role '%s'", role);
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(branch)).delete()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(expectedErrorMsg);
        } else {
            ((DeleteBranchBuilder)this.api().deleteBranch().branch(branch)).delete();
        }
    }

    private void readContent(String branchName, ContentKey key, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Content)((GetContentBuilder)this.api().getContent().refName(branchName)).key(key).get().get(key)).unwrap(IcebergTable.class).get()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'READ_ENTITY_VALUE' is not allowed for role '%s' on content '%s'", role, key.toPathString()));
        } else {
            ((ObjectAssert)Assertions.assertThat((Object)((IcebergTable)((Content)((GetContentBuilder)this.api().getContent().refName(branchName)).key(key).get().get(key)).unwrap(IcebergTable.class).get())).isNotNull()).isInstanceOf(IcebergTable.class);
        }
    }

    private void getEntriesFor(String branchName, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)this.api().getEntries().refName(branchName)).get().getEntries()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'READ_ENTRIES' is not allowed for role '%s' on reference", role));
        } else {
            List tables = ((GetEntriesBuilder)this.api().getEntries().refName(branchName)).get().getEntries();
            Assertions.assertThat((List)tables).isNotEmpty();
        }
    }

    private void getCommitLog(String branchName, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.api().getCommitLog().refName(branchName)).get().getLogEntries()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'LIST_COMMIT_LOG' is not allowed for role '%s' on reference", role));
        } else {
            List commits = ((GetCommitLogBuilder)this.api().getCommitLog().refName(branchName)).get().getLogEntries();
            Assertions.assertThat((List)commits).isNotEmpty();
        }
    }

    private void getRefLog(String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api().getRefLog().get().getLogEntries()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'VIEW_REFLOG' is not allowed for role '%s'", role));
        } else {
            List entries = this.api().getRefLog().get().getLogEntries();
            Assertions.assertThat((List)entries).isNotEmpty();
        }
    }

    private void addContent(Branch branch, Operation.Put put, String role, boolean shouldFail) throws BaseNessieClientServerException {
        CommitMultipleOperationsBuilder commitOp = ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).operation((Operation)put).commitMeta(CommitMeta.fromMessage((String)"add stuff"));
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)commitOp).commit()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'COMMIT_CHANGE_AGAINST_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            commitOp.commit();
        }
    }

    private void deleteContent(Branch branch, Operation.Delete delete, String role, boolean shouldFail) throws BaseNessieClientServerException {
        CommitMultipleOperationsBuilder commitOp = ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).operation((Operation)delete).commitMeta(CommitMeta.fromMessage((String)"delete stuff"));
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)commitOp).commit()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'COMMIT_CHANGE_AGAINST_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            commitOp.commit();
        }
    }
}

