/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import io.quarkus.test.security.TestSecurity;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

class AbstractTestBasicOperations {
    private NessieApiV1 api;

    AbstractTestBasicOperations() {
    }

    @AfterEach
    void closeClient() {
        if (this.api != null) {
            this.api.close();
            this.api = null;
        }
    }

    void getCatalog(String branch) throws BaseNessieClientServerException {
        this.api = (NessieApiV1)((HttpClientBuilder)HttpClientBuilder.builder().withUri("http://localhost:19121/api/v1")).build(NessieApiV1.class);
        if (branch != null) {
            this.api.createReference().reference((Reference)Branch.of((String)branch, null)).sourceRefName("main").create();
        }
    }

    void tryEndpointPass(Executable runnable) {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)runnable);
    }

    @Test
    @TestSecurity(user="admin_user", roles={"admin", "user"})
    void testAdmin() throws BaseNessieClientServerException {
        this.getCatalog("testx");
        Branch branch = (Branch)this.api.getReference().refName("testx").get();
        List tables = ((GetEntriesBuilder)this.api.getEntries().refName("testx")).get().getEntries();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tables.isEmpty());
        ContentKey key = ContentKey.of((String[])new String[]{"x", "x"});
        this.tryEndpointPass(() -> ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)key, (Content)IcebergTable.of((String)"foo", (long)42L, (int)42, (int)42, (int)42, (String)"cid-foo"))).commitMeta(CommitMeta.fromMessage((String)"empty message")).commit());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Content)((GetContentBuilder)this.api.getContent().refName("testx")).key(key).get().get(key)).unwrap(IcebergTable.class).isPresent());
        Branch master = (Branch)this.api.getReference().refName("testx").get();
        Branch test = Branch.of((String)"testy", (String)master.getHash());
        this.tryEndpointPass(() -> this.api.createReference().sourceRefName(master.getName()).reference((Reference)test).create());
        Branch test2 = (Branch)this.api.getReference().refName("testy").get();
        this.tryEndpointPass(() -> ((DeleteBranchBuilder)this.api.deleteBranch().branch(test2)).delete());
        this.tryEndpointPass(() -> ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(master)).operation((Operation)Operation.Delete.of((ContentKey)key)).commitMeta(CommitMeta.fromMessage((String)"")).commit());
        Assertions.assertThat((Map)((GetContentBuilder)this.api.getContent().refName("testx")).key(key).get()).isEmpty();
        this.tryEndpointPass(() -> {
            Branch b = (Branch)this.api.getReference().refName(branch.getName()).get();
            ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(b)).operation((Operation)Operation.Put.of((ContentKey)key, (Content)IcebergTable.of((String)"bar", (long)42L, (int)42, (int)42, (int)42, (String)"cid-bar"))).commitMeta(CommitMeta.fromMessage((String)"")).commit();
        });
    }

    @Test
    @TestSecurity(authorizationEnabled=false)
    void testUserCleanup() throws BaseNessieClientServerException {
        this.getCatalog(null);
        Branch r = (Branch)this.api.getReference().refName("testx").get();
        ((DeleteBranchBuilder)this.api.deleteBranch().branch(r)).delete();
    }
}

