/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.authn;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.projectnessie.server.config.QuarkusNessieAuthenticationConfig;

@Alternative
@Priority(value=1)
@ApplicationScoped
public class NessieHttpAuthenticator
extends HttpAuthenticator {
    private final IdentityProviderManager identityProvider;
    private final boolean authEnabled;

    public NessieHttpAuthenticator() {
        super(null, null, new EmptyInstance(), null);
        this.identityProvider = null;
        this.authEnabled = false;
    }

    @Inject
    public NessieHttpAuthenticator(QuarkusNessieAuthenticationConfig config, IdentityProviderManager identityProviderManager, Instance<PathMatchingHttpSecurityPolicy> pathMatchingPolicy, Instance<HttpAuthenticationMechanism> httpAuthenticationMechanism, Instance<IdentityProvider<?>> providers) {
        super(identityProviderManager, pathMatchingPolicy, httpAuthenticationMechanism, providers);
        this.identityProvider = identityProviderManager;
        this.authEnabled = config.enabled();
    }

    public Uni<SecurityIdentity> attemptAuthentication(RoutingContext context) {
        if (!this.authEnabled) {
            return this.anonymous();
        }
        return super.attemptAuthentication(context).onItem().transform(securityIdentity -> {
            if (securityIdentity == null) {
                throw new AuthenticationFailedException("Missing or unrecognized credentials");
            }
            return securityIdentity;
        });
    }

    private Uni<SecurityIdentity> anonymous() {
        return this.identityProvider.authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE);
    }

    static class EmptyInstance<T>
    implements Instance<T> {
        EmptyInstance() {
        }

        public Instance<T> select(Annotation ... qualifiers) {
            return null;
        }

        public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
            return null;
        }

        public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
            return null;
        }

        public boolean isUnsatisfied() {
            return false;
        }

        public boolean isAmbiguous() {
            return false;
        }

        public void destroy(T instance) {
        }

        public Iterator<T> iterator() {
            return Collections.emptyListIterator();
        }

        public T get() {
            return null;
        }
    }
}

