/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server.providers;

import com.dremio.nessie.error.NessieError;
import com.dremio.nessie.services.config.ServerConfig;
import com.google.common.base.Throwables;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseExceptionMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseExceptionMapper.class);

    protected BaseExceptionMapper() {
    }

    Response buildExceptionResponse(int status, String reason, String message, Exception e) {
        InjectableInstance injectableInstance = Arc.container().select(ServerConfig.class, new Annotation[0]);
        ServerConfig serverConfig = (ServerConfig)injectableInstance.get();
        return this.buildExceptionResponse(status, reason, message, e, serverConfig.shouldSendstackTraceToAPIClient(), h -> {});
    }

    Response buildExceptionResponse(int status, String reason, String message, Exception e, boolean includeExceptionStackTrace, Consumer<Response.ResponseBuilder> responseHandler) {
        String stack = includeExceptionStackTrace ? Throwables.getStackTraceAsString((Throwable)e) : null;
        NessieError error = new NessieError(message, status, reason, stack);
        LOGGER.debug("Failure on server, propagated to client. Status: {} {}, Message: {}.", new Object[]{status, reason, message, e});
        Response.ResponseBuilder responseBuilder = Response.status((int)status).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE);
        responseHandler.accept(responseBuilder);
        return responseBuilder.build();
    }
}

