/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server.providers;

import com.dremio.nessie.error.BaseNessieClientServerException;
import com.dremio.nessie.server.providers.BaseExceptionMapper;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class NessieExceptionMapper
extends BaseExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieExceptionMapper.class);

    public Response toResponse(Exception exception) {
        String reason;
        int status;
        if (exception instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)exception;
            Response.Status st = Response.Status.fromStatusCode((int)e.getResponse().getStatus());
            status = st.getStatusCode();
            reason = st.getReasonPhrase();
        } else if (exception instanceof BaseNessieClientServerException) {
            LOGGER.debug("Exception on server with appropriate error sent to client.", (Throwable)exception);
            BaseNessieClientServerException e = (BaseNessieClientServerException)exception;
            status = e.getStatus();
            reason = e.getReason();
        } else if (exception instanceof JsonParseException || exception instanceof JsonMappingException) {
            status = Response.Status.BAD_REQUEST.getStatusCode();
            reason = Response.Status.BAD_REQUEST.getReasonPhrase();
        } else {
            status = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
            reason = Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase();
        }
        return this.buildExceptionResponse(status, reason, exception.getMessage(), exception);
    }
}

