/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.server.providers;

import com.dremio.nessie.server.providers.BaseExceptionMapper;
import javax.enterprise.inject.Alternative;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.api.validation.ResteasyViolationException;

@Alternative
@Provider
public class ResteasyExceptionMapper
extends BaseExceptionMapper
implements ExceptionMapper<ValidationException> {
    public Response toResponse(ValidationException exception) {
        ResteasyViolationException violationException;
        Exception e;
        if (exception instanceof ResteasyViolationException && (e = (violationException = (ResteasyViolationException)exception).getException()) == null) {
            boolean returnValueViolation = !violationException.getReturnValueViolations().isEmpty();
            Response.Status st = returnValueViolation ? Response.Status.INTERNAL_SERVER_ERROR : Response.Status.BAD_REQUEST;
            return this.buildExceptionResponse(st.getStatusCode(), st.getReasonPhrase(), exception.getMessage(), (Exception)exception, false, b -> b.header("validation-exception", (Object)"true"));
        }
        return this.buildExceptionResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), this.unwrapException((Throwable)exception), (Exception)exception);
    }

    protected String unwrapException(Throwable t) {
        StringBuffer sb = new StringBuffer();
        this.doUnwrapException(sb, t);
        return sb.toString();
    }

    private void doUnwrapException(StringBuffer sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t.toString());
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            this.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }
}

