/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import io.quarkus.runtime.Startup;
import java.io.IOError;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.server.config.VersionStoreConfig;
import org.projectnessie.server.providers.StoreType;
import org.projectnessie.server.providers.VersionStoreFactory;
import org.projectnessie.server.store.TableCommitMetaStoreWorker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ConfigurableVersionStoreFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableVersionStoreFactory.class);
    private final Instance<VersionStoreFactory> versionStoreFactory;
    private final VersionStoreConfig storeConfig;
    private final ServerConfig serverConfig;
    private static final long START_RETRY_MIN_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private volatile long lastUnsuccessfulStart = 0L;

    @Inject
    public ConfigurableVersionStoreFactory(@Any Instance<VersionStoreFactory> versionStoreFactory, VersionStoreConfig storeConfig, ServerConfig serverConfig) {
        this.versionStoreFactory = versionStoreFactory;
        this.storeConfig = storeConfig;
        this.serverConfig = serverConfig;
    }

    @Produces
    @Singleton
    @Startup
    public VersionStore<Contents, CommitMeta> getVersionStore() {
        VersionStore<Contents, CommitMeta> store = this.newVersionStore();
        try (Stream str = store.getNamedRefs();){
            if (!str.findFirst().isPresent()) {
                try {
                    store.create((NamedRef)BranchName.of((String)this.serverConfig.getDefaultBranch()), Optional.empty());
                }
                catch (ReferenceAlreadyExistsException | ReferenceNotFoundException e) {
                    LOGGER.warn("Failed to create default branch of {}.", (Object)this.serverConfig.getDefaultBranch(), (Object)e);
                }
            }
        }
        return store;
    }

    private VersionStore<Contents, CommitMeta> newVersionStore() {
        VersionStoreConfig.VersionStoreType versionStoreType = this.storeConfig.getVersionStoreType();
        if (System.nanoTime() - this.lastUnsuccessfulStart < START_RETRY_MIN_INTERVAL_NANOS) {
            LOGGER.warn("{} version store failed to start recently, try again later.", (Object)versionStoreType);
            throw new RuntimeException(String.format("%s version store failed to start recently, try again later.", new Object[]{versionStoreType}));
        }
        try {
            VersionStore versionStore;
            VersionStoreFactory factory = (VersionStoreFactory)this.versionStoreFactory.select(new Annotation[]{new StoreType.Literal(versionStoreType)}).get();
            LOGGER.info("Using {} Version store", (Object)versionStoreType);
            try {
                versionStore = factory.newStore(new TableCommitMetaStoreWorker());
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            this.lastUnsuccessfulStart = 0L;
            return versionStore;
        }
        catch (IOError | RuntimeException e) {
            this.lastUnsuccessfulStart = System.nanoTime();
            LOGGER.error("Failed to configure/start {} version store", (Object)versionStoreType, (Object)e);
            throw e;
        }
    }
}

