/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.projectnessie.server.config.DynamoVersionStoreConfig;
import org.projectnessie.server.config.VersionStoreConfig;
import org.projectnessie.server.providers.StoreType;
import org.projectnessie.server.providers.VersionStoreFactory;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.dynamodb.DynamoStore;
import org.projectnessie.versioned.dynamodb.DynamoStoreConfig;
import org.projectnessie.versioned.impl.TieredVersionStore;
import org.projectnessie.versioned.store.Store;
import software.amazon.awssdk.regions.Region;

@StoreType(value=VersionStoreConfig.VersionStoreType.DYNAMO)
@Dependent
public class DynamoVersionStoreFactory
implements VersionStoreFactory {
    private final DynamoVersionStoreConfig config;
    private final String region;
    private final Optional<String> endpoint;

    @Inject
    public DynamoVersionStoreFactory(DynamoVersionStoreConfig config, @ConfigProperty(name="quarkus.dynamodb.aws.region") String region, @ConfigProperty(name="quarkus.dynamodb.endpoint-override") Optional<String> endpoint) {
        this.config = config;
        this.region = region;
        this.endpoint = endpoint;
    }

    @Override
    public <VALUE, METADATA> VersionStore<VALUE, METADATA> newStore(StoreWorker<VALUE, METADATA> worker) throws IOException {
        return new TieredVersionStore(worker, (Store)this.newDynamoConnection(), false);
    }

    private DynamoStore newDynamoConnection() {
        DynamoStore dynamo = new DynamoStore((DynamoStoreConfig)DynamoStoreConfig.builder().endpoint(this.endpoint.map(e -> {
            try {
                return new URI((String)e);
            }
            catch (URISyntaxException uriSyntaxException) {
                throw new RuntimeException(uriSyntaxException);
            }
        })).region(Region.of((String)this.region)).initializeDatabase(this.config.isDynamoInitialize()).tablePrefix(this.config.getTablePrefix()).enableTracing(this.config.enableTracing()).build());
        dynamo.start();
        return dynamo;
    }
}

