/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import java.io.File;
import java.io.IOException;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.lib.Repository;
import org.projectnessie.server.config.JGitVersionStoreConfig;
import org.projectnessie.server.config.VersionStoreConfig;
import org.projectnessie.server.providers.StoreType;
import org.projectnessie.server.providers.VersionStoreFactory;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.jgit.JGitVersionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StoreType(value=VersionStoreConfig.VersionStoreType.JGIT)
@Dependent
public class JGitVersionStoreFactory
implements VersionStoreFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitVersionStoreFactory.class);
    private final JGitVersionStoreConfig config;

    @Inject
    public JGitVersionStoreFactory(JGitVersionStoreConfig config) {
        this.config = config;
    }

    @Override
    public <VALUE, METADATA> VersionStore<VALUE, METADATA> newStore(StoreWorker<VALUE, METADATA> worker) throws IOException {
        Repository repository = this.newRepository();
        return new JGitVersionStore(repository, worker);
    }

    private Repository newRepository() throws IOException {
        switch (this.config.getJgitStoreType()) {
            case DISK: {
                LOGGER.info("JGit Version store has been configured with the file backend");
                File jgitDir = new File(this.config.getJgitDirectory().orElseThrow(() -> new RuntimeException("Please set nessie.version.store.jgit.directory")));
                if (!jgitDir.exists() && !jgitDir.mkdirs()) {
                    throw new RuntimeException(String.format("Couldn't create file at %s", this.config.getJgitDirectory().get()));
                }
                LOGGER.info("File backend is at {}", (Object)jgitDir.getAbsolutePath());
                try {
                    return Git.init().setDirectory(jgitDir).call().getRepository();
                }
                catch (GitAPIException e) {
                    throw new IOException(e);
                }
            }
            case INMEMORY: {
                LOGGER.info("JGit Version store has been configured with the in memory backend");
                return ((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription())).build();
            }
        }
        throw new RuntimeException(String.format("unknown jgit repo type %s", new Object[]{this.config.getJgitStoreType()}));
    }
}

