/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.authz;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.server.authz.CompiledAuthorizationRules;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.Check;

final class CelBatchAccessChecker
extends AbstractBatchAccessChecker {
    private final CompiledAuthorizationRules compiledRules;
    private final AccessContext context;

    CelBatchAccessChecker(CompiledAuthorizationRules compiledRules, AccessContext context) {
        this.compiledRules = compiledRules;
        this.context = context;
    }

    public Map<Check, String> check() {
        LinkedHashMap<Check, String> failed = new LinkedHashMap<Check, String>();
        this.getChecks().forEach(check -> {
            if (check.type().isContent()) {
                this.canPerformOpOnPath((Check)check, (Map<Check, String>)failed);
            } else if (check.type().isRef()) {
                this.canPerformOpOnReference((Check)check, (Map<Check, String>)failed);
            } else {
                this.canPerformOp((Check)check, (Map<Check, String>)failed);
            }
        });
        return failed;
    }

    private String getRoleName() {
        return null != this.context.user() ? this.context.user().getName() : "";
    }

    private void canPerformOp(Check check, Map<Check, String> failed) {
        String roleName = this.getRoleName();
        ImmutableMap arguments = ImmutableMap.of((Object)"role", (Object)roleName, (Object)"op", (Object)check.type().name(), (Object)"path", (Object)"", (Object)"ref", (Object)"", (Object)"contentType", (Object)"");
        Supplier<String> errorMsgSupplier = () -> String.format("'%s' is not allowed for role '%s' ", check.type(), roleName);
        this.canPerformOp((Map<String, Object>)arguments, check, errorMsgSupplier, failed);
    }

    private void canPerformOpOnReference(Check check, Map<Check, String> failed) {
        String roleName = this.getRoleName();
        ImmutableMap arguments = ImmutableMap.of((Object)"ref", (Object)check.ref().getName(), (Object)"role", (Object)roleName, (Object)"op", (Object)check.type().name(), (Object)"path", (Object)"", (Object)"contentType", (Object)"");
        Supplier<String> errorMsgSupplier = () -> String.format("'%s' is not allowed for role '%s' on reference '%s'", check.type(), roleName, check.ref().getName());
        this.canPerformOp((Map<String, Object>)arguments, check, errorMsgSupplier, failed);
    }

    private void canPerformOpOnPath(Check check, Map<Check, String> failed) {
        String roleName = this.getRoleName();
        ImmutableMap arguments = ImmutableMap.of((Object)"ref", (Object)check.ref().getName(), (Object)"path", (Object)check.key().toPathString(), (Object)"role", (Object)roleName, (Object)"op", (Object)check.type().name(), (Object)"contentType", (Object)(check.contentType() != null ? check.contentType().name() : ""));
        Supplier<String> errorMsgSupplier = () -> String.format("'%s' is not allowed for role '%s' on content '%s'", check.type(), roleName, check.key().toPathString());
        this.canPerformOp((Map<String, Object>)arguments, check, errorMsgSupplier, failed);
    }

    private void canPerformOp(Map<String, Object> arguments, Check check, Supplier<String> errorMessageSupplier, Map<Check, String> failed) {
        boolean allowed = this.compiledRules.getRules().entrySet().stream().anyMatch(entry -> {
            try {
                return (Boolean)((Script)entry.getValue()).execute(Boolean.class, arguments);
            }
            catch (ScriptException e) {
                throw new RuntimeException(String.format("Failed to execute authorization rule with id '%s' due to: %s", entry.getKey(), e.getMessage()), e);
            }
        });
        if (!allowed) {
            failed.put(check, errorMessageSupplier.get());
        }
    }
}

