/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.authz;

import com.google.common.collect.ImmutableMap;
import io.quarkus.runtime.Startup;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.server.config.QuarkusNessieAuthorizationConfig;
import org.projectnessie.services.authz.Check;
import org.projectnessie.services.cel.CELUtil;

@Singleton
@Startup
public class CompiledAuthorizationRules {
    private final QuarkusNessieAuthorizationConfig config;
    private final Map<String, Script> compiledRules;
    private static final String ALLOW_VIEWING_ALL_REFS_ID = "__ALLOW_VIEWING_REF_ID";
    private static final String ALLOW_VIEWING_ALL_REFS = String.format("op=='%s' && ref.matches('.*')", Check.CheckType.VIEW_REFERENCE);

    @Inject
    public CompiledAuthorizationRules(QuarkusNessieAuthorizationConfig config) {
        this.config = config;
        this.compiledRules = this.compileAuthorizationRules();
    }

    private Map<String, Script> compileAuthorizationRules() {
        HashMap<String, String> rules = new HashMap<String, String>(this.config.rules());
        if (rules.entrySet().stream().noneMatch(r -> ((String)r.getValue()).contains(Check.CheckType.VIEW_REFERENCE.name()))) {
            rules.put(ALLOW_VIEWING_ALL_REFS_ID, ALLOW_VIEWING_ALL_REFS);
        }
        HashMap scripts = new HashMap();
        rules.forEach((key, value) -> scripts.computeIfAbsent(value, k -> {
            try {
                return CELUtil.SCRIPT_HOST.buildScript(value).withContainer("org.projectnessie.model").withDeclarations(CELUtil.AUTHORIZATION_RULE_DECLARATIONS).build();
            }
            catch (ScriptException e) {
                throw new RuntimeException(String.format("Failed to compile authorization rule with id '%s' and expression '%s' due to: %s", key, value, e.getMessage()), e);
            }
        }));
        return ImmutableMap.copyOf(scripts);
    }

    public Map<String, Script> getRules() {
        return this.compiledRules;
    }
}

