/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.authn;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.projectnessie.server.config.QuarkusNessieAuthenticationConfig;

@Alternative
@Priority(value=1)
@Singleton
public class NessieHttpAuthenticator
extends HttpAuthenticator {
    private final IdentityProviderManager identityProvider;
    private final boolean authEnabled;
    private final Set<String> anonymousPaths;

    @Inject
    public NessieHttpAuthenticator(QuarkusNessieAuthenticationConfig config, IdentityProviderManager identityProviderManager, Instance<PathMatchingHttpSecurityPolicy> pathMatchingPolicy, Instance<HttpAuthenticationMechanism> httpAuthenticationMechanism, Instance<IdentityProvider<?>> providers) {
        super(identityProviderManager, pathMatchingPolicy, httpAuthenticationMechanism, providers);
        this.identityProvider = identityProviderManager;
        this.authEnabled = config.enabled();
        this.anonymousPaths = config.anonymousPaths();
    }

    public Uni<SecurityIdentity> attemptAuthentication(RoutingContext context) {
        if (!this.authEnabled) {
            return this.anonymous();
        }
        return super.attemptAuthentication(context).onItem().transformToUni(securityIdentity -> {
            if (securityIdentity == null) {
                String path = context.request().path();
                if (path != null && this.anonymousPaths.contains(path)) {
                    return this.anonymous();
                }
                throw new AuthenticationFailedException("Missing or unrecognized credentials");
            }
            return Uni.createFrom().item(securityIdentity);
        });
    }

    private Uni<SecurityIdentity> anonymous() {
        return this.identityProvider.authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE);
    }
}

