/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.rest;

import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.restjavax.BaseExceptionMapper;

@Provider
public class ResteasyExceptionMapper
extends BaseExceptionMapper<ResteasyViolationException> {
    public ResteasyExceptionMapper() {
        this(null);
    }

    @Inject
    public ResteasyExceptionMapper(ServerConfig config) {
        super(config);
    }

    public Response toResponse(ResteasyViolationException exception) {
        Exception e = exception.getException();
        if (e == null) {
            boolean returnValueViolation = !exception.getReturnValueViolations().isEmpty();
            ErrorCode errorCode = returnValueViolation ? ErrorCode.UNKNOWN : ErrorCode.BAD_REQUEST;
            return this.buildExceptionResponse(errorCode, exception.getMessage(), (Exception)exception, false, b -> b.header("validation-exception", (Object)"true"));
        }
        return this.buildExceptionResponse(ErrorCode.UNKNOWN, ResteasyExceptionMapper.unwrapException((Throwable)exception), (Exception)exception);
    }

    protected static String unwrapException(Throwable t) {
        StringBuilder sb = new StringBuilder();
        ResteasyExceptionMapper.doUnwrapException(sb, t);
        return sb.toString();
    }

    private static void doUnwrapException(StringBuilder sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t);
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            ResteasyExceptionMapper.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }
}

