/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.error;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.quarkus.test.junit.QuarkusTest;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.rest.NessieBackendThrottledException;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.server.error.OtherEntity;

@QuarkusTest
class TestNessieError {
    static String baseURI = "http://localhost:19121/api/v1/nessieErrorTest";
    private static HttpClient client;

    TestNessieError() {
    }

    @BeforeAll
    static void setup() {
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        client = HttpClient.builder().setBaseUri(URI.create(baseURI)).setObjectMapper(mapper).build();
        client.register((ResponseFilter)new NessieHttpResponseFilter(mapper));
    }

    @Test
    void nullParameterQueryGet() {
        Assertions.assertEquals((Object)"Bad Request (HTTP/400): nullParameterQueryGet.hash: must not be null", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("nullParameterQueryGet").get())).getMessage());
    }

    @Test
    void nullParameterQueryPost() {
        Assertions.assertEquals((Object)"Bad Request (HTTP/400): nullParameterQueryPost.hash: must not be null", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("nullParameterQueryPost").post((Object)""))).getMessage());
    }

    @Test
    void emptyParameterQueryGet() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): emptyParameterQueryGet.hash: must not be empty", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("emptyParameterQueryGet").get())).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): emptyParameterQueryGet.hash: must not be empty", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("emptyParameterQueryGet").queryParam("hash", "").get())).getMessage())});
    }

    @Test
    void blankParameterQueryGet() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): blankParameterQueryGet.hash: must not be blank", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("blankParameterQueryGet").get())).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): blankParameterQueryGet.hash: must not be blank", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("blankParameterQueryGet").queryParam("hash", "").get())).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): blankParameterQueryGet.hash: must not be blank", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("blankParameterQueryGet").queryParam("hash", "   ").get())).getMessage())});
    }

    @Test
    void entityValueViolation() {
        Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("basicEntity").put((Object)"not really valid json"))).getMessage(), (Matcher)CoreMatchers.startsWith((String)"Bad Request (HTTP/400): Unrecognized token 'not': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')\n")), () -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("basicEntity").put((Object)"{}"))).getMessage(), (Matcher)CoreMatchers.startsWith((String)"Bad Request (HTTP/400): Missing required creator property 'value' (index 0)\n")), () -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("basicEntity").put((Object)"{\"value\":null}"))).getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Bad Request (HTTP/400): basicEntity.entity.value: must not be null")), () -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> client.newRequest().path("basicEntity").put((Object)"{\"value\":1.234}"))).getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Bad Request (HTTP/400): basicEntity.entity.value: must be greater than or equal to 3"))});
    }

    @Test
    void brokenEntitySerialization() {
        MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.unwrap(() -> client.newRequest().path("basicEntity").put((Object)new OtherEntity("bar"))))).getMessage(), (Matcher)CoreMatchers.startsWith((String)"Bad Request (HTTP/400): Missing required creator property 'value' (index 0)\n"));
    }

    @Test
    void nessieNotFoundException() {
        NessieNotFoundException ex = (NessieNotFoundException)Assertions.assertThrows(NessieNotFoundException.class, () -> this.unwrap(() -> client.newRequest().path("nessieNotFound").get()));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"not-there-message", (Object)ex.getMessage()), () -> Assertions.assertNull((Object)ex.getServerStackTrace()), () -> Assertions.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)ex.getStatus())});
    }

    @Test
    void nonConstraintValidationExceptions() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"Internal Server Error (HTTP/500): javax.validation.ConstraintDefinitionException: meep", (Object)((NessieInternalServerException)Assertions.assertThrows(NessieInternalServerException.class, () -> this.unwrap(() -> client.newRequest().path("constraintDefinitionException").get()))).getMessage()), () -> Assertions.assertEquals((Object)"Internal Server Error (HTTP/500): javax.validation.ConstraintDeclarationException: meep", (Object)((NessieInternalServerException)Assertions.assertThrows(NessieInternalServerException.class, () -> this.unwrap(() -> client.newRequest().path("constraintDeclarationException").get()))).getMessage()), () -> Assertions.assertEquals((Object)"Internal Server Error (HTTP/500): javax.validation.GroupDefinitionException: meep", (Object)((NessieInternalServerException)Assertions.assertThrows(NessieInternalServerException.class, () -> this.unwrap(() -> client.newRequest().path("groupDefinitionException").get()))).getMessage())});
    }

    @Test
    void unhandledRuntimeExceptionInStore() {
        Assertions.assertEquals((Object)"Internal Server Error (HTTP/500): java.lang.RuntimeException: Store.getValues-throwing", (Object)((NessieInternalServerException)Assertions.assertThrows(NessieInternalServerException.class, () -> client.newRequest().path("unhandledExceptionInTvsStore/runtime").get())).getMessage());
    }

    @Test
    void backendThrottledExceptionInStore() {
        Assertions.assertEquals((Object)"Too Many Requests (HTTP/429): Backend store refused to process the request: org.projectnessie.versioned.BackendLimitExceededException: Store.getValues-throttled", (Object)((NessieBackendThrottledException)Assertions.assertThrows(NessieBackendThrottledException.class, () -> client.newRequest().path("unhandledExceptionInTvsStore/throttle").get())).getMessage());
    }

    void unwrap(Executable exec) throws Throwable {
        try {
            exec.execute();
        }
        catch (Throwable targetException) {
            if (targetException instanceof HttpClientException && (targetException.getCause() instanceof NessieNotFoundException || targetException.getCause() instanceof NessieConflictException)) {
                throw targetException.getCause();
            }
            throw targetException;
        }
    }
}

