/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableList;
import io.quarkus.test.junit.QuarkusTest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.Hash;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableMerge;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.MultiGetContentsRequest;
import org.projectnessie.model.MultiGetContentsResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.SqlView;
import org.projectnessie.model.Tag;
import org.projectnessie.server.ReferenceMatchers;

@QuarkusTest
class TestRest {
    public static final String COMMA_VALID_HASH_1 = ",1234567890123456789012345678901234567890123456789012345678901234";
    public static final String COMMA_VALID_HASH_2 = ",1234567890123456789012345678901234567890";
    public static final String COMMA_VALID_HASH_3 = ",1234567890123456";
    private NessieClient client;
    private TreeApi tree;
    private ContentsApi contents;
    private HttpClient httpClient;

    TestRest() {
    }

    @BeforeEach
    void init() {
        URI uri = URI.create("http://localhost:19121/api/v1");
        this.client = NessieClient.builder().withUri(uri).build();
        this.tree = this.client.getTreeApi();
        this.contents = this.client.getContentsApi();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.httpClient = HttpClient.builder().setBaseUri(uri).setObjectMapper(mapper).build();
        this.httpClient.register((ResponseFilter)new NessieHttpResponseFilter(mapper));
    }

    @AfterEach
    void closeClient() {
        this.client.close();
    }

    @Test
    void illegalArgumentException() {
        MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.createReference((Reference)Hash.of((String)"12341234cafebeef")))).getMessage(), (Matcher)Matchers.startsWith((String)"Bad Request (HTTP/400): Only tag and branch references can be created"));
    }

    @ParameterizedTest
    @ValueSource(strings={"normal", "with-no_space", "slash/thing"})
    void referenceNames(String refNamePart) throws NessieNotFoundException, NessieConflictException {
        String tagName = "tag" + refNamePart;
        String branchName = "branch" + refNamePart;
        String branchName2 = "branch2" + refNamePart;
        String someHash = this.tree.getReferenceByName("main").getHash();
        this.tree.createReference((Reference)Tag.of((String)tagName, (String)someHash));
        this.tree.createReference((Reference)Branch.of((String)branchName, (String)someHash));
        this.tree.createReference((Reference)Branch.of((String)branchName2, (String)someHash));
        Map references = this.tree.getAllReferences().stream().filter(r -> "main".equals(r.getName()) || r.getName().endsWith(refNamePart)).collect(Collectors.toMap(Reference::getName, Function.identity()));
        MatcherAssert.assertThat(references.values(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ReferenceMatchers.referenceWithNameAndType("main", Branch.class), ReferenceMatchers.referenceWithNameAndType(tagName, Tag.class), ReferenceMatchers.referenceWithNameAndType(branchName, Branch.class), ReferenceMatchers.referenceWithNameAndType(branchName2, Branch.class)}));
        Reference tagRef = (Reference)references.get(tagName);
        Reference branchRef = (Reference)references.get(branchName);
        Reference branchRef2 = (Reference)references.get(branchName2);
        String tagHash = tagRef.getHash();
        String branchHash = branchRef.getHash();
        String branchHash2 = branchRef2.getHash();
        MatcherAssert.assertThat((Object)this.tree.getReferenceByName(tagName), (Matcher)Matchers.equalTo((Object)tagRef));
        MatcherAssert.assertThat((Object)this.tree.getReferenceByName(branchName), (Matcher)Matchers.equalTo((Object)branchRef));
        EntriesResponse entries = this.tree.getEntries(tagName, null, null, Collections.emptyList());
        MatcherAssert.assertThat((Object)entries, (Matcher)Matchers.notNullValue());
        entries = this.tree.getEntries(branchName, null, null, Collections.emptyList());
        MatcherAssert.assertThat((Object)entries, (Matcher)Matchers.notNullValue());
        LogResponse log = this.tree.getCommitLog(tagName, null, null);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.notNullValue());
        log = this.tree.getCommitLog(branchName, null, null);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.notNullValue());
        ImmutablePut op = ImmutablePut.builder().key(ContentsKey.of((String[])new String[]{"some-key"})).contents((Contents)IcebergTable.of((String)"foo")).build();
        ImmutableOperations ops = ImmutableOperations.builder().addOperations((Operation)op).commitMeta(CommitMeta.fromMessage((String)"One dummy op")).build();
        this.tree.commitMultipleOperations(branchName, branchHash, (Operations)ops);
        log = this.tree.getCommitLog(branchName, null, null);
        String newHash = ((CommitMeta)log.getOperations().get(0)).getHash();
        this.tree.assignTag(tagName, tagHash, Tag.of((String)tagName, (String)newHash));
        this.tree.assignBranch(branchName, newHash, Branch.of((String)branchName, (String)newHash));
        this.tree.mergeRefIntoBranch(branchName2, branchHash2, (Merge)ImmutableMerge.builder().fromHash(newHash).build());
        this.tree.deleteTag(tagName, newHash);
        this.tree.deleteBranch(branchName, newHash);
    }

    @Test
    void commitLogPaging() throws NessieNotFoundException, NessieConflictException {
        String someHash = this.tree.getReferenceByName("main").getHash();
        String branchName = "commitLogPaging";
        Branch branch = Branch.of((String)branchName, (String)someHash);
        this.tree.createReference((Reference)branch);
        int commits = 95;
        int pageSizeHint = 10;
        String currentHash = someHash;
        ArrayList<String> allMessages = new ArrayList<String>();
        for (int i = 0; i < commits; ++i) {
            String msg = "message-for-" + i;
            allMessages.add(msg);
            this.contents.setContents(ContentsKey.of((String[])new String[]{"table"}), branchName, currentHash, msg, (Contents)IcebergTable.of((String)("some-file-" + i)));
            currentHash = this.tree.getReferenceByName(branchName).getHash();
        }
        Collections.reverse(allMessages);
        String pageToken = null;
        for (int pos = 0; pos < commits; pos += pageSizeHint) {
            LogResponse response = this.tree.getCommitLog(branchName, Integer.valueOf(pageSizeHint), pageToken);
            if (pos + pageSizeHint > commits) {
                Assertions.assertFalse((boolean)response.hasMore());
                Assertions.assertNull((Object)response.getToken());
                Assertions.assertEquals(allMessages.subList(pos, allMessages.size()), response.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList()));
                break;
            }
            Assertions.assertTrue((boolean)response.hasMore());
            Assertions.assertNotNull((Object)response.getToken());
            Assertions.assertEquals(allMessages.subList(pos, pos + pageSizeHint), response.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList()));
            pageToken = response.getToken();
        }
        List completeLog = StreamingUtil.getCommitLogStream((TreeApi)this.tree, (String)branchName, (OptionalInt)OptionalInt.of(pageSizeHint)).collect(Collectors.toList());
        Assertions.assertEquals(completeLog.stream().map(CommitMeta::getMessage).collect(Collectors.toList()), allMessages);
    }

    @Test
    void multiget() throws NessieNotFoundException, NessieConflictException {
        String branch = "foo";
        this.tree.createReference((Reference)Branch.of((String)"foo", null));
        Reference r = this.tree.getReferenceByName("foo");
        ContentsKey a = ContentsKey.of((String[])new String[]{"a"});
        ContentsKey b = ContentsKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        IcebergTable tb = IcebergTable.of((String)"path2");
        this.contents.setContents(a, "foo", r.getHash(), "commit 1", (Contents)ta);
        this.contents.setContents(b, "foo", r.getHash(), "commit 2", (Contents)tb);
        List keys = this.contents.getMultipleContents("foo", MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{a, b, ContentsKey.of((String[])new String[]{"noexist"})})).getContents();
        List<MultiGetContentsResponse.ContentsWithKey> expected = Arrays.asList(MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)a, (Contents)ta), MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)b, (Contents)tb));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.containsInAnyOrder((Object[])expected.toArray()));
        this.tree.deleteBranch("foo", this.tree.getReferenceByName("foo").getHash());
    }

    @Test
    void filters() throws NessieNotFoundException, NessieConflictException {
        String branch = "filterTypes";
        this.tree.createReference((Reference)Branch.of((String)"filterTypes", null));
        Reference r = this.tree.getReferenceByName("filterTypes");
        ContentsKey a = ContentsKey.of((String[])new String[]{"a"});
        ContentsKey b = ContentsKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        ImmutableSqlView tb = ImmutableSqlView.builder().sqlText("select * from table").dialect(SqlView.Dialect.DREMIO).build();
        this.contents.setContents(a, "filterTypes", r.getHash(), "commit 1", (Contents)ta);
        this.contents.setContents(b, "filterTypes", r.getHash(), "commit 2", (Contents)tb);
        List entries = this.tree.getEntries("filterTypes", null, null, Collections.emptyList()).getEntries();
        List<EntriesResponse.Entry> expected = Arrays.asList(EntriesResponse.Entry.builder().name(a).type(Contents.Type.ICEBERG_TABLE).build(), EntriesResponse.Entry.builder().name(b).type(Contents.Type.VIEW).build());
        MatcherAssert.assertThat((Object)entries, (Matcher)Matchers.containsInAnyOrder((Object[])expected.toArray()));
        entries = this.tree.getEntries("filterTypes", null, null, (List)ImmutableList.of((Object)Contents.Type.ICEBERG_TABLE.name())).getEntries();
        Assertions.assertEquals(Collections.singletonList(expected.get(0)), (Object)entries);
        entries = this.tree.getEntries("filterTypes", null, null, (List)ImmutableList.of((Object)Contents.Type.VIEW.name())).getEntries();
        Assertions.assertEquals(Collections.singletonList(expected.get(1)), (Object)entries);
        entries = this.tree.getEntries("filterTypes", null, null, (List)ImmutableList.of((Object)Contents.Type.VIEW.name(), (Object)Contents.Type.ICEBERG_TABLE.name())).getEntries();
        MatcherAssert.assertThat((Object)entries, (Matcher)Matchers.containsInAnyOrder((Object[])expected.toArray()));
        this.tree.deleteBranch("filterTypes", this.tree.getReferenceByName("filterTypes").getHash());
    }

    @Test
    void checkSpecialCharacterRoundTrip() throws NessieNotFoundException, NessieConflictException {
        String branch = "specialchar";
        this.tree.createReference((Reference)Branch.of((String)"specialchar", null));
        Reference r = this.tree.getReferenceByName("specialchar");
        ContentsKey k = ContentsKey.of((String[])new String[]{"a.b", "c.d"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        this.contents.setContents(k, "specialchar", r.getHash(), "commit 1", (Contents)ta);
        Assertions.assertEquals((Object)MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)k, (Contents)ta), this.contents.getMultipleContents("specialchar", MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{k})).getContents().get(0));
        Assertions.assertEquals((Object)ta, (Object)this.contents.getContents(k, "specialchar"));
        this.tree.deleteBranch("specialchar", this.tree.getReferenceByName("specialchar").getHash());
    }

    @Test
    void checkServerErrorPropagation() throws NessieNotFoundException, NessieConflictException {
        String branch = "bar";
        this.tree.createReference((Reference)Branch.of((String)"bar", null));
        NessieConflictException e = (NessieConflictException)Assertions.assertThrows(NessieConflictException.class, () -> this.tree.createReference((Reference)Branch.of((String)"bar", null)));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"already exists"));
    }

    @ParameterizedTest
    @CsvSource(value={"x/,1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidBranchNames(String invalidBranchName, String validHash) {
        ImmutableOperations ops = ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)"")).build();
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        IcebergTable cts = IcebergTable.of((String)"moo");
        MultiGetContentsRequest mgReq = MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{key});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        Assertions.assertAll((Executable[])new Executable[]{() -> this.lambda$invalidBranchNames$4(invalidBranchName, validHash, (Operations)ops), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteBranch(invalidBranchName, validHash))).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): getCommitLog.ref: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.getCommitLog(invalidBranchName, null, null))).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): getEntries.refName: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.getEntries(invalidBranchName, null, null, Collections.emptyList()))).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): getReferenceByName.refName: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.getReferenceByName(invalidBranchName))).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): assignTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.assignTag(invalidBranchName, validHash, tag))).getMessage()), () -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.mergeRefIntoBranch(invalidBranchName, validHash, null))).getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Bad Request (HTTP/400): "), (Matcher)Matchers.containsString((String)"mergeRefIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), (Matcher)Matchers.containsString((String)"mergeRefIntoBranch.merge: must not be null"))), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteTag(invalidBranchName, validHash))).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): transplantCommitsIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.transplantCommitsIntoBranch(invalidBranchName, validHash, null, null))).getMessage()), () -> this.lambda$invalidBranchNames$22(key, invalidBranchName, validHash, (Contents)cts), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteContents.branch: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.deleteContents(key, invalidBranchName, validHash, null))).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): getContents.ref: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.getContents(key, invalidBranchName))).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): getMultipleContents.ref: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.getMultipleContents(invalidBranchName, mgReq))).getMessage())});
    }

    @ParameterizedTest
    @CsvSource(value={",1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidHashes(String invalidHashIn, String validHash) {
        String invalidHash = invalidHashIn != null ? invalidHashIn : "";
        String validBranchName = "hello";
        ImmutableOperations ops = ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)"")).build();
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        IcebergTable cts = IcebergTable.of((String)"moo");
        MultiGetContentsRequest mgReq = MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{key});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        Assertions.assertAll((Executable[])new Executable[]{() -> this.lambda$invalidHashes$30(validBranchName, invalidHash, (Operations)ops), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteBranch.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteBranch(validBranchName, invalidHash))).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): assignTag.oldHash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.assignTag(validBranchName, invalidHash, tag))).getMessage()), () -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.mergeRefIntoBranch(validBranchName, invalidHash, null))).getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Bad Request (HTTP/400): "), (Matcher)Matchers.containsString((String)"mergeRefIntoBranch.merge: must not be null"), (Matcher)Matchers.containsString((String)"mergeRefIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes"))), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteTag.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteTag(validBranchName, invalidHash))).getMessage()), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): transplantCommitsIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.transplantCommitsIntoBranch(validBranchName, invalidHash, null, null))).getMessage()), () -> this.lambda$invalidHashes$42(key, validBranchName, invalidHash, (Contents)cts), () -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteContents.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.deleteContents(key, validBranchName, invalidHash, null))).getMessage()), () -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.getMultipleContents(invalidHash, null))).getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Bad Request (HTTP/400): "), (Matcher)Matchers.containsString((String)"getMultipleContents.request: must not be null"), (Matcher)Matchers.containsString((String)"getMultipleContents.ref: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes")))});
    }

    @ParameterizedTest
    @CsvSource(value={",1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidTags(String invalidTagNameIn, String validHash) {
        String invalidTagName = invalidTagNameIn != null ? invalidTagNameIn : "";
        String validBranchName = "hello";
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        MultiGetContentsRequest mgReq = MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{key});
        String tag = "{\"type\": \"TAG\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String branch = "{\"type\": \"BRANCH\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String different = "{\"type\": \"FOOBAR\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"Bad Request (HTTP/400): assignTag.tag: must not be null", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put(null)))).getMessage()), () -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)tag)))).getMessage(), (Matcher)Matchers.startsWith((String)("Bad Request (HTTP/400): Cannot construct instance of `org.projectnessie.model.ImmutableTag`, problem: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + invalidTagName + "\n"))), () -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)branch)))).getMessage(), (Matcher)Matchers.startsWith((String)"Bad Request (HTTP/400): Could not resolve type id 'BRANCH' as a subtype of `org.projectnessie.model.Tag`: Class `org.projectnessie.model.Branch` not subtype of `org.projectnessie.model.Tag`\n")), () -> MatcherAssert.assertThat((Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)different)))).getMessage(), (Matcher)Matchers.startsWith((String)"Bad Request (HTTP/400): Could not resolve type id 'FOOBAR' as a subtype of `org.projectnessie.model.Tag`: known type ids = []\n"))});
    }

    void unwrap(Executable exec) throws Throwable {
        try {
            exec.execute();
        }
        catch (Throwable targetException) {
            if (targetException instanceof HttpClientException && (targetException.getCause() instanceof NessieNotFoundException || targetException.getCause() instanceof NessieConflictException)) {
                throw targetException.getCause();
            }
            throw targetException;
        }
    }

    private /* synthetic */ void lambda$invalidHashes$42(ContentsKey key, String validBranchName, String invalidHash, Contents cts) throws Throwable {
        Assertions.assertEquals((Object)"Bad Request (HTTP/400): setContents.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.setContents(key, validBranchName, invalidHash, null, cts))).getMessage());
    }

    private /* synthetic */ void lambda$invalidHashes$30(String validBranchName, String invalidHash, Operations ops) throws Throwable {
        Assertions.assertEquals((Object)"Bad Request (HTTP/400): commitMultipleOperations.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.commitMultipleOperations(validBranchName, invalidHash, ops))).getMessage());
    }

    private /* synthetic */ void lambda$invalidBranchNames$22(ContentsKey key, String invalidBranchName, String validHash, Contents cts) throws Throwable {
        Assertions.assertEquals((Object)"Bad Request (HTTP/400): setContents.branch: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.setContents(key, invalidBranchName, validHash, null, cts))).getMessage());
    }

    private /* synthetic */ void lambda$invalidBranchNames$4(String invalidBranchName, String validHash, Operations ops) throws Throwable {
        Assertions.assertEquals((Object)"Bad Request (HTTP/400): commitMultipleOperations.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.commitMultipleOperations(invalidBranchName, validHash, ops))).getMessage());
    }
}

