/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import javax.annotation.Nonnull;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.projectnessie.model.Reference;

public final class ReferenceMatchers {
    public static Matcher<Reference> referenceWithName(@Nonnull String refName) {
        return new ReferenceByNameMatcher(refName, null);
    }

    public static Matcher<Reference> referenceWithNameAndType(@Nonnull String refName, @Nonnull Class<? extends Reference> type) {
        return new ReferenceByNameMatcher(refName, type);
    }

    static class ReferenceByNameMatcher
    extends BaseMatcher<Reference> {
        private final String refName;
        private final Class<? extends Reference> type;

        ReferenceByNameMatcher(@Nonnull String refName, Class<? extends Reference> type) {
            this.refName = refName;
            this.type = type;
        }

        public boolean matches(Object o) {
            if (!(o instanceof Reference)) {
                return false;
            }
            Reference ref = (Reference)o;
            return this.refName.equals(ref.getName()) && (this.type == null || this.type.isInstance(ref));
        }

        public void describeTo(Description description) {
            description.appendText("reference with name ").appendText(this.refName);
            if (this.type != null) {
                description.appendText(" and type " + this.type.getSimpleName());
            }
        }
    }
}

