/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.providers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.projectnessie.server.config.DynamoVersionStoreConfig;
import org.projectnessie.server.config.VersionStoreConfig;
import org.projectnessie.server.providers.StoreType;
import org.projectnessie.server.providers.VersionStoreFactory;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.dynamodb.DynamoStore;
import org.projectnessie.versioned.dynamodb.DynamoStoreConfig;
import org.projectnessie.versioned.impl.ImmutableTieredVersionStoreConfig;
import org.projectnessie.versioned.impl.TieredVersionStore;
import org.projectnessie.versioned.impl.TieredVersionStoreConfig;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.store.TracingStore;
import software.amazon.awssdk.regions.Region;

@StoreType(value=VersionStoreConfig.VersionStoreType.DYNAMO)
@Dependent
public class DynamoVersionStoreFactory
implements VersionStoreFactory {
    private final DynamoVersionStoreConfig config;
    private final String region;
    private final Optional<String> endpoint;

    @Inject
    public DynamoVersionStoreFactory(DynamoVersionStoreConfig config, @ConfigProperty(name="quarkus.dynamodb.aws.region") String region, @ConfigProperty(name="quarkus.dynamodb.endpoint-override") Optional<String> endpoint) {
        this.config = config;
        this.region = region;
        this.endpoint = endpoint;
    }

    @Override
    public <VALUE, METADATA, VALUE_TYPE extends Enum<VALUE_TYPE>> VersionStore<VALUE, METADATA, VALUE_TYPE> newStore(StoreWorker<VALUE, METADATA, VALUE_TYPE> worker) {
        return new TieredVersionStore(worker, this.newDynamoConnection(), (TieredVersionStoreConfig)ImmutableTieredVersionStoreConfig.builder().enableTracing(this.config.enableTracing()).build());
    }

    private Store newDynamoConnection() {
        DynamoStore store = new DynamoStore((DynamoStoreConfig)DynamoStoreConfig.builder().endpoint(this.endpoint.map(e -> {
            try {
                return new URI((String)e);
            }
            catch (URISyntaxException uriSyntaxException) {
                throw new RuntimeException(uriSyntaxException);
            }
        })).region(Region.of((String)this.region)).initializeDatabase(this.config.isDynamoInitialize()).tablePrefix(this.config.getTablePrefix()).enableTracing(this.config.enableTracing()).build());
        if (this.config.enableTracing()) {
            store = new TracingStore((Store)store);
        }
        store.start();
        return store;
    }
}

