/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableList;
import io.quarkus.test.junit.QuarkusTest;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.Hash;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableMerge;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.MultiGetContentsRequest;
import org.projectnessie.model.MultiGetContentsResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.SqlView;
import org.projectnessie.model.Tag;

@QuarkusTest
class TestRest {
    public static final String COMMA_VALID_HASH_1 = ",1234567890123456789012345678901234567890123456789012345678901234";
    public static final String COMMA_VALID_HASH_2 = ",1234567890123456789012345678901234567890";
    public static final String COMMA_VALID_HASH_3 = ",1234567890123456";
    private NessieClient client;
    private TreeApi tree;
    private ContentsApi contents;
    private HttpClient httpClient;

    TestRest() {
    }

    @BeforeEach
    void init() {
        URI uri = URI.create("http://localhost:19121/api/v1");
        this.client = NessieClient.builder().withUri(uri).build();
        this.tree = this.client.getTreeApi();
        this.contents = this.client.getContentsApi();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.httpClient = HttpClient.builder().setBaseUri(uri).setObjectMapper(mapper).build();
        this.httpClient.register((ResponseFilter)new NessieHttpResponseFilter(mapper));
    }

    @AfterEach
    void closeClient() {
        this.client.close();
    }

    @Test
    void createReferences() throws NessieNotFoundException {
        String mainHash = this.tree.getReferenceByName("main").getHash();
        String tagName1 = "createReferences_tag1";
        String tagName2 = "createReferences_tag2";
        String branchName1 = "createReferences_branch1";
        String branchName2 = "createReferences_branch2";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.createReference((Reference)Tag.of((String)tagName1, null))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot create an unassigned tag reference"), () -> {
            Reference refTag1 = this.tree.createReference((Reference)Tag.of((String)tagName2, (String)mainHash));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName2, (String)mainHash), (Object)refTag1);
        }, () -> {
            Reference refBranch1 = this.tree.createReference((Reference)Branch.of((String)branchName1, null));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName1, (String)mainHash), (Object)refBranch1);
        }, () -> {
            Reference refBranch2 = this.tree.createReference((Reference)Branch.of((String)branchName2, (String)mainHash));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)mainHash), (Object)refBranch2);
        }, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.createReference((Reference)Hash.of((String)"cafebabedeafbeef"))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Only tag and branch references can be created")});
    }

    @ParameterizedTest
    @ValueSource(strings={"normal", "with-no_space", "slash/thing"})
    void referenceNames(String refNamePart) throws NessieNotFoundException, NessieConflictException {
        String tagName = "tag" + refNamePart;
        String branchName = "branch" + refNamePart;
        String branchName2 = "branch2" + refNamePart;
        Reference main = this.tree.getReferenceByName("main");
        String someHash = main.getHash();
        Reference createdTag = this.tree.createReference((Reference)Tag.of((String)tagName, (String)someHash));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName, (String)someHash), (Object)createdTag);
        Reference createdBranch1 = this.tree.createReference((Reference)Branch.of((String)branchName, (String)someHash));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName, (String)someHash), (Object)createdBranch1);
        Reference createdBranch2 = this.tree.createReference((Reference)Branch.of((String)branchName2, (String)someHash));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)someHash), (Object)createdBranch2);
        Map references = this.tree.getAllReferences().stream().filter(r -> "main".equals(r.getName()) || r.getName().endsWith(refNamePart)).collect(Collectors.toMap(Reference::getName, Function.identity()));
        Assertions.assertThat(references).containsAllEntriesOf(Map.of(main.getName(), main, createdTag.getName(), createdTag, createdBranch1.getName(), createdBranch1, createdBranch2.getName(), createdBranch2));
        Assertions.assertThat((Object)((Reference)references.get(main.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdTag.getName()))).isInstanceOf(Tag.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch1.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch2.getName()))).isInstanceOf(Branch.class);
        Reference tagRef = (Reference)references.get(tagName);
        Reference branchRef = (Reference)references.get(branchName);
        Reference branchRef2 = (Reference)references.get(branchName2);
        String tagHash = tagRef.getHash();
        String branchHash = branchRef.getHash();
        String branchHash2 = branchRef2.getHash();
        Assertions.assertThat((Object)this.tree.getReferenceByName(tagName)).isEqualTo((Object)tagRef);
        Assertions.assertThat((Object)this.tree.getReferenceByName(branchName)).isEqualTo((Object)branchRef);
        EntriesResponse entries = this.tree.getEntries(tagName, null, null, Collections.emptyList());
        Assertions.assertThat((Object)entries).isNotNull();
        entries = this.tree.getEntries(branchName, null, null, Collections.emptyList());
        Assertions.assertThat((Object)entries).isNotNull();
        LogResponse log = this.tree.getCommitLog(tagName, null, null);
        Assertions.assertThat((Object)log).isNotNull();
        log = this.tree.getCommitLog(branchName, null, null);
        Assertions.assertThat((Object)log).isNotNull();
        ImmutablePut op = ImmutablePut.builder().key(ContentsKey.of((String[])new String[]{"some-key"})).contents((Contents)IcebergTable.of((String)"foo")).build();
        ImmutableOperations ops = ImmutableOperations.builder().addOperations((Operation)op).commitMeta(CommitMeta.fromMessage((String)"One dummy op")).build();
        this.tree.commitMultipleOperations(branchName, branchHash, (Operations)ops);
        log = this.tree.getCommitLog(branchName, null, null);
        String newHash = ((CommitMeta)log.getOperations().get(0)).getHash();
        this.tree.assignTag(tagName, tagHash, Tag.of((String)tagName, (String)newHash));
        this.tree.assignBranch(branchName, newHash, Branch.of((String)branchName, (String)newHash));
        this.tree.mergeRefIntoBranch(branchName2, branchHash2, (Merge)ImmutableMerge.builder().fromHash(newHash).build());
        this.tree.deleteTag(tagName, newHash);
        this.tree.deleteBranch(branchName, newHash);
    }

    @Test
    void commitLogPaging() throws NessieNotFoundException, NessieConflictException {
        String someHash = this.tree.getReferenceByName("main").getHash();
        String branchName = "commitLogPaging";
        Branch branch = Branch.of((String)branchName, (String)someHash);
        this.tree.createReference((Reference)branch);
        int commits = 95;
        int pageSizeHint = 10;
        String currentHash = someHash;
        ArrayList<CallSite> allMessages = new ArrayList<CallSite>();
        for (int i = 0; i < commits; ++i) {
            String msg = "message-for-" + i;
            allMessages.add((CallSite)((Object)msg));
            String nextHash = this.tree.commitMultipleOperations(branchName, currentHash, (Operations)ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)msg)).addOperations((Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"table"}), (Contents)IcebergTable.of((String)("some-file-" + i)))).build()).getHash();
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)currentHash, (Object)nextHash);
            currentHash = nextHash;
        }
        Collections.reverse(allMessages);
        String pageToken = null;
        for (int pos = 0; pos < commits; pos += pageSizeHint) {
            LogResponse response = this.tree.getCommitLog(branchName, Integer.valueOf(pageSizeHint), pageToken);
            if (pos + pageSizeHint > commits) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMore());
                org.junit.jupiter.api.Assertions.assertNull((Object)response.getToken());
                org.junit.jupiter.api.Assertions.assertEquals(allMessages.subList(pos, allMessages.size()), response.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList()));
                break;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMore());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)response.getToken());
            org.junit.jupiter.api.Assertions.assertEquals(allMessages.subList(pos, pos + pageSizeHint), response.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList()));
            pageToken = response.getToken();
        }
        List completeLog = StreamingUtil.getCommitLogStream((TreeApi)this.tree, (String)branchName, (OptionalInt)OptionalInt.of(pageSizeHint)).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(completeLog.stream().map(CommitMeta::getMessage).collect(Collectors.toList()), allMessages);
    }

    @Test
    void multiget() throws NessieNotFoundException, NessieConflictException {
        String branch = "foo";
        Reference r = this.tree.createReference((Reference)Branch.of((String)"foo", null));
        ContentsKey a = ContentsKey.of((String[])new String[]{"a"});
        ContentsKey b = ContentsKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        IcebergTable tb = IcebergTable.of((String)"path2");
        this.contents.setContents(a, "foo", r.getHash(), "commit 1", (Contents)ta);
        this.contents.setContents(b, "foo", r.getHash(), "commit 2", (Contents)tb);
        List keys = this.contents.getMultipleContents("foo", MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{a, b, ContentsKey.of((String[])new String[]{"noexist"})})).getContents();
        List<MultiGetContentsResponse.ContentsWithKey> expected = Arrays.asList(MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)a, (Contents)ta), MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)b, (Contents)tb));
        Assertions.assertThat((List)keys).containsExactlyInAnyOrderElementsOf(expected);
        this.tree.deleteBranch("foo", this.tree.getReferenceByName("foo").getHash());
    }

    @Test
    void filters() throws NessieNotFoundException, NessieConflictException {
        String branch = "filterTypes";
        Reference r = this.tree.createReference((Reference)Branch.of((String)"filterTypes", null));
        ContentsKey a = ContentsKey.of((String[])new String[]{"a"});
        ContentsKey b = ContentsKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        ImmutableSqlView tb = ImmutableSqlView.builder().sqlText("select * from table").dialect(SqlView.Dialect.DREMIO).build();
        this.contents.setContents(a, "filterTypes", r.getHash(), "commit 1", (Contents)ta);
        this.contents.setContents(b, "filterTypes", r.getHash(), "commit 2", (Contents)tb);
        List entries = this.tree.getEntries("filterTypes", null, null, Collections.emptyList()).getEntries();
        List<EntriesResponse.Entry> expected = Arrays.asList(EntriesResponse.Entry.builder().name(a).type(Contents.Type.ICEBERG_TABLE).build(), EntriesResponse.Entry.builder().name(b).type(Contents.Type.VIEW).build());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
        entries = this.tree.getEntries("filterTypes", null, null, (List)ImmutableList.of((Object)Contents.Type.ICEBERG_TABLE.name())).getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(0)), (Object)entries);
        entries = this.tree.getEntries("filterTypes", null, null, (List)ImmutableList.of((Object)Contents.Type.VIEW.name())).getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(1)), (Object)entries);
        entries = this.tree.getEntries("filterTypes", null, null, (List)ImmutableList.of((Object)Contents.Type.VIEW.name(), (Object)Contents.Type.ICEBERG_TABLE.name())).getEntries();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
        this.tree.deleteBranch("filterTypes", this.tree.getReferenceByName("filterTypes").getHash());
    }

    @Test
    void checkSpecialCharacterRoundTrip() throws NessieNotFoundException, NessieConflictException {
        String branch = "specialchar";
        Reference r = this.tree.createReference((Reference)Branch.of((String)"specialchar", null));
        ContentsKey k = ContentsKey.of((String[])new String[]{"a.b", "c.d"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        this.contents.setContents(k, "specialchar", r.getHash(), "commit 1", (Contents)ta);
        org.junit.jupiter.api.Assertions.assertEquals((Object)MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)k, (Contents)ta), this.contents.getMultipleContents("specialchar", MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{k})).getContents().get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ta, (Object)this.contents.getContents(k, "specialchar"));
        this.tree.deleteBranch("specialchar", this.tree.getReferenceByName("specialchar").getHash());
    }

    @Test
    void checkServerErrorPropagation() throws NessieNotFoundException, NessieConflictException {
        String branch = "bar";
        this.tree.createReference((Reference)Branch.of((String)"bar", null));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.createReference((Reference)Branch.of((String)"bar", null))).isInstanceOf(NessieConflictException.class)).hasMessageContaining("already exists");
    }

    @ParameterizedTest
    @CsvSource(value={"x/,1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidBranchNames(String invalidBranchName, String validHash) {
        ImmutableOperations ops = ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)"")).build();
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        IcebergTable cts = IcebergTable.of((String)"moo");
        MultiGetContentsRequest mgReq = MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{key});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> this.lambda$invalidBranchNames$10(invalidBranchName, validHash, (Operations)ops), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteBranch(invalidBranchName, validHash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getCommitLog.ref: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.getCommitLog(invalidBranchName, null, null))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getEntries.refName: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.getEntries(invalidBranchName, null, null, Collections.emptyList()))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getReferenceByName.refName: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.getReferenceByName(invalidBranchName))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): assignTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.assignTag(invalidBranchName, validHash, tag))).getMessage()), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.mergeRefIntoBranch(invalidBranchName, validHash, null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("mergeRefIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..").hasMessageContaining("mergeRefIntoBranch.merge: must not be null"), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteTag(invalidBranchName, validHash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): transplantCommitsIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.transplantCommitsIntoBranch(invalidBranchName, validHash, null, null))).getMessage()), () -> this.lambda$invalidBranchNames$28(key, invalidBranchName, validHash, (Contents)cts), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteContents.branch: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.deleteContents(key, invalidBranchName, validHash, null))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getContents.ref: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.getContents(key, invalidBranchName))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getMultipleContents.ref: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.getMultipleContents(invalidBranchName, mgReq))).getMessage())});
    }

    @ParameterizedTest
    @CsvSource(value={",1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidHashes(String invalidHashIn, String validHash) {
        String invalidHash = invalidHashIn != null ? invalidHashIn : "";
        String validBranchName = "hello";
        ImmutableOperations ops = ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)"")).build();
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        IcebergTable cts = IcebergTable.of((String)"moo");
        MultiGetContentsRequest mgReq = MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{key});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> this.lambda$invalidHashes$36(validBranchName, invalidHash, (Operations)ops), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteBranch.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteBranch(validBranchName, invalidHash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): assignTag.oldHash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.assignTag(validBranchName, invalidHash, tag))).getMessage()), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.mergeRefIntoBranch(validBranchName, invalidHash, null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("mergeRefIntoBranch.merge: must not be null").hasMessageContaining("mergeRefIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteTag.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteTag(validBranchName, invalidHash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): transplantCommitsIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.transplantCommitsIntoBranch(validBranchName, invalidHash, null, null))).getMessage()), () -> this.lambda$invalidHashes$48(key, validBranchName, invalidHash, (Contents)cts), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteContents.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.deleteContents(key, validBranchName, invalidHash, null))).getMessage()), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.contents.getMultipleContents(invalidHash, null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("getMultipleContents.request: must not be null").hasMessageContaining("getMultipleContents.ref: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes")});
    }

    @ParameterizedTest
    @CsvSource(value={",1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidTags(String invalidTagNameIn, String validHash) {
        String invalidTagName = invalidTagNameIn != null ? invalidTagNameIn : "";
        String validBranchName = "hello";
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        MultiGetContentsRequest mgReq = MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{key});
        String tag = "{\"type\": \"TAG\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String branch = "{\"type\": \"BRANCH\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String different = "{\"type\": \"FOOBAR\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put(null))).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): assignTag.tag: must not be null"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)tag))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot construct instance of `org.projectnessie.model.ImmutableTag`, problem: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + invalidTagName + "\n"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)branch))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Could not resolve type id 'BRANCH' as a subtype of `org.projectnessie.model.Tag`: Class `org.projectnessie.model.Branch` not subtype of `org.projectnessie.model.Tag`\n"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)different))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Could not resolve type id 'FOOBAR' as a subtype of `org.projectnessie.model.Tag`: known type ids = []\n")});
    }

    void unwrap(Executable exec) throws Throwable {
        try {
            exec.execute();
        }
        catch (Throwable targetException) {
            if (targetException instanceof HttpClientException && (targetException.getCause() instanceof NessieNotFoundException || targetException.getCause() instanceof NessieConflictException)) {
                throw targetException.getCause();
            }
            throw targetException;
        }
    }

    private /* synthetic */ void lambda$invalidHashes$48(ContentsKey key, String validBranchName, String invalidHash, Contents cts) throws Throwable {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): setContents.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.setContents(key, validBranchName, invalidHash, null, cts))).getMessage());
    }

    private /* synthetic */ void lambda$invalidHashes$36(String validBranchName, String invalidHash, Operations ops) throws Throwable {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): commitMultipleOperations.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.commitMultipleOperations(validBranchName, invalidHash, ops))).getMessage());
    }

    private /* synthetic */ void lambda$invalidBranchNames$28(ContentsKey key, String invalidBranchName, String validHash, Contents cts) throws Throwable {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): setContents.branch: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.setContents(key, invalidBranchName, validHash, null, cts))).getMessage());
    }

    private /* synthetic */ void lambda$invalidBranchNames$10(String invalidBranchName, String validHash, Operations ops) throws Throwable {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): commitMultipleOperations.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.commitMultipleOperations(invalidBranchName, validHash, ops))).getMessage());
    }
}

