/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.security.TestSecurity;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.time.Instant;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

@QuarkusTest
public class RestGitTest {
    @BeforeEach
    public void enableLogging() {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @Test
    @TestSecurity(authorizationEnabled=false)
    public void testBasic() {
        int preSize = ((Reference[])((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().get("trees", new Object[0])).then()).statusCode(200)).extract().as(Reference[].class)).length;
        ((ValidatableResponse)((Response)RestGitTest.rest().get("trees/tree/mainx", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestGitTest.rest().body((Object)Branch.of((String)"mainx", null)).post("trees/tree", new Object[0])).then()).statusCode(200);
        Reference[] references = (Reference[])((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().get("trees", new Object[0])).then()).statusCode(200)).extract().as(Reference[].class);
        org.junit.jupiter.api.Assertions.assertEquals((int)(preSize + 1), (int)references.length);
        Reference reference = (Reference)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().get("trees/tree/mainx", new Object[0])).then()).statusCode(200)).extract().as(Reference.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mainx", (Object)reference.getName());
        ImmutableBranch newReference = ImmutableBranch.builder().hash(reference.getHash()).name("test").build();
        ((ValidatableResponse)((Response)RestGitTest.rest().queryParam("expectedHash", new Object[]{reference.getHash()}).body((Object)Branch.of((String)"test", null)).post("trees/tree", new Object[0])).then()).statusCode(200);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newReference, (Object)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().get("trees/tree/test", new Object[0])).then()).statusCode(200)).extract().as(Branch.class));
        IcebergTable table = IcebergTable.of((String)"/the/directory/over/there");
        ((ValidatableResponse)((Response)RestGitTest.rest().body((Object)table).queryParam("branch", new Object[]{newReference.getName()}).queryParam("hash", new Object[]{newReference.getHash()}).post("contents/xxx.test", new Object[0])).then()).statusCode(204);
        Operation.Put[] updates = new Operation.Put[11];
        for (int i = 0; i < 10; ++i) {
            updates[i] = ImmutablePut.builder().key(ContentsKey.of((String[])new String[]{"item", Integer.toString(i)})).contents((Contents)ImmutableIcebergTable.builder().from(table).metadataLocation("/the/directory/over/there/" + i).build()).build();
        }
        updates[10] = ImmutablePut.builder().key(ContentsKey.of((String[])new String[]{"xxx", "test"})).contents((Contents)ImmutableIcebergTable.builder().from(table).metadataLocation("/the/directory/over/there/has/been/moved").build()).build();
        Reference branch = (Reference)((Response)RestGitTest.rest().get("trees/tree/test", new Object[0])).as(Reference.class);
        ImmutableOperations contents = ImmutableOperations.builder().addOperations((Operation[])updates).commitMeta(CommitMeta.fromMessage((String)"")).build();
        Branch commitResponse = (Branch)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().body((Object)contents).queryParam("expectedHash", new Object[]{branch.getHash()}).post("trees/branch/{branch}/commit", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(Branch.class);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)branch.getHash(), (Object)commitResponse.getHash());
        Response res = (Response)((ValidatableResponse)((Response)RestGitTest.rest().queryParam("ref", new Object[]{"test"}).get("contents/xxx.test", new Object[0])).then()).extract().response();
        org.junit.jupiter.api.Assertions.assertEquals((Object)updates[10].getContents(), (Object)res.body().as(Contents.class));
        table = ImmutableIcebergTable.builder().from(table).metadataLocation("/the/directory/over/there/has/been/moved/again").build();
        Branch b2 = (Branch)((Response)RestGitTest.rest().get("trees/tree/test", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)RestGitTest.rest().body((Object)table).queryParam("branch", new Object[]{b2.getName()}).queryParam("hash", new Object[]{b2.getHash()}).post("contents/xxx.test", new Object[0])).then()).statusCode(204);
        Contents returned = (Contents)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().queryParam("ref", new Object[]{"test"}).get("contents/xxx.test", new Object[0])).then()).statusCode(200)).extract().as(Contents.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)table, (Object)returned);
        Branch b3 = (Branch)((Response)RestGitTest.rest().get("trees/tree/test", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)RestGitTest.rest().body((Object)Tag.of((String)"tagtest", (String)b3.getHash())).post("trees/tree", new Object[0])).then()).statusCode(200);
        Assertions.assertThat((String)((Tag)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().get("trees/tree/tagtest", new Object[0])).then()).statusCode(200)).extract().body().as(Tag.class)).getHash()).isEqualTo(b3.getHash());
        ((ValidatableResponse)((Response)RestGitTest.rest().queryParam("expectedHash", new Object[]{"0011223344556677889900112233445566778899001122334455667788990011".substring(0, b2.getHash().length())}).delete("trees/tag/tagtest", new Object[0])).then()).statusCode(409);
        ((ValidatableResponse)((Response)RestGitTest.rest().queryParam("expectedHash", new Object[]{b3.getHash()}).delete("trees/tag/tagtest", new Object[0])).then()).statusCode(204);
        LogResponse log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().get("trees/tree/test/log", new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)log.getOperations().size());
        Branch b1 = (Branch)((Response)RestGitTest.rest().get("trees/tree/test", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)RestGitTest.rest().queryParam("expectedHash", new Object[]{b1.getHash()}).delete("trees/branch/test", new Object[0])).then()).statusCode(204);
        Branch bx = (Branch)((Response)RestGitTest.rest().get("trees/tree/mainx", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)RestGitTest.rest().queryParam("expectedHash", new Object[]{bx.getHash()}).delete("trees/branch/mainx", new Object[0])).then()).statusCode(204);
    }

    private static RequestSpecification rest() {
        return RestAssured.given().when().basePath("/api/v1/").contentType(ContentType.JSON);
    }

    private Branch commit(Branch branch, String contentsKey, String metadataUrl) {
        return this.commit(branch, contentsKey, metadataUrl, "nessieAuthor");
    }

    private Branch commit(Branch branch, String contentsKey, String metadataUrl, String author) {
        ImmutableOperations contents = ImmutableOperations.builder().addOperations((Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{contentsKey}), (Contents)IcebergTable.of((String)metadataUrl))).commitMeta((CommitMeta)CommitMeta.builder().author(author).message("").build()).build();
        return (Branch)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().body((Object)contents).queryParam("expectedHash", new Object[]{branch.getHash()}).post("trees/branch/{branch}/commit", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(Branch.class);
    }

    private Branch getBranch(String name) {
        return (Branch)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().get("trees/tree/{name}", new Object[]{name})).then()).statusCode(200)).extract().as(Branch.class);
    }

    private Branch makeBranch(String name) {
        ImmutableBranch test = ImmutableBranch.builder().name(name).build();
        ((ValidatableResponse)((Response)RestGitTest.rest().body((Object)test).post("trees/tree", new Object[0])).then()).statusCode(200);
        return test;
    }

    @Test
    @TestSecurity(authorizationEnabled=false)
    public void testOptimisticLocking() {
        this.makeBranch("test3");
        Branch b1 = this.getBranch("test3");
        String newHash = this.commit(b1, "xxx.test", "/the/directory/over/there").getHash();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)b1.getHash(), (Object)newHash);
        Branch b2 = this.getBranch("test3");
        newHash = this.commit(b2, "xxx.test", "/the/directory/over/there/has/been/moved").getHash();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)b2.getHash(), (Object)newHash);
        Branch b3 = this.getBranch("test3");
        newHash = this.commit(b3, "xxx.test", "/the/directory/over/there/has/been/moved/again").getHash();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)b3.getHash(), (Object)newHash);
    }

    @Test
    @TestSecurity(authorizationEnabled=false)
    public void testLogFiltering() {
        String branchName = "logFiltering";
        this.makeBranch(branchName);
        Branch branch = this.getBranch(branchName);
        int numCommits = 3;
        for (int i = 0; i < numCommits; ++i) {
            String newHash = this.commit(branch, "xxx.test", "/the/directory/over/there", "author-" + i).getHash();
            Assertions.assertThat((String)newHash).isNotEqualTo((Object)branch.getHash());
            branch = this.getBranch(branchName);
        }
        LogResponse log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(numCommits);
        Instant firstCommitTime = ((CommitMeta)log.getOperations().get(log.getOperations().size() - 1)).getCommitTime();
        Instant lastCommitTime = ((CommitMeta)log.getOperations().get(0)).getCommitTime();
        Assertions.assertThat((Instant)firstCommitTime).isNotNull();
        Assertions.assertThat((Instant)lastCommitTime).isNotNull();
        String author = "author-1";
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().queryParam("authors", new Object[]{author}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(1);
        Assertions.assertThat((String)((CommitMeta)log.getOperations().get(0)).getAuthor()).isEqualTo(author);
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().queryParam("after", new Object[]{firstCommitTime.toString()}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(numCommits - 1);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isAfter(firstCommitTime));
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().queryParam("before", new Object[]{lastCommitTime.toString()}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(numCommits - 1);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isBefore(lastCommitTime));
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestGitTest.rest().queryParam("before", new Object[]{lastCommitTime.toString()}).queryParam("after", new Object[]{firstCommitTime.toString()}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(1);
        Assertions.assertThat((Instant)((CommitMeta)log.getOperations().get(0)).getCommitTime()).isBefore(lastCommitTime).isAfter(firstCommitTime);
    }
}

