/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.security.TestSecurity;
import java.io.IOException;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.rest.NessieForbiddenException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.Reference;

@QuarkusTest
class TestAuth {
    private NessieClient client;
    private TreeApi tree;
    private ContentsApi contents;

    TestAuth() {
    }

    @AfterEach
    void closeClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    void getCatalog(String branch) throws NessieNotFoundException, NessieConflictException {
        this.client = NessieClient.builder().withUri("http://localhost:19121/api/v1").build();
        this.tree = this.client.getTreeApi();
        this.contents = this.client.getContentsApi();
        if (branch != null) {
            this.tree.createReference((Reference)Branch.of((String)branch, null));
        }
    }

    void tryEndpointPass(Executable runnable) {
        Assertions.assertDoesNotThrow((Executable)runnable);
    }

    void tryEndpointFail(Executable runnable) {
        Assertions.assertThrows(NessieForbiddenException.class, (Executable)runnable);
    }

    @Disabled
    @Test
    void testLogin() {
        Assertions.assertThrows(NessieNotAuthorizedException.class, () -> this.getCatalog("x"));
    }

    @Test
    @TestSecurity(user="admin_user", roles={"admin", "user"})
    void testAdmin() throws NessieNotFoundException, NessieConflictException {
        this.getCatalog("testx");
        Branch branch = (Branch)this.tree.getReferenceByName("testx");
        List tables = this.tree.getEntries("testx", EntriesParams.empty()).getEntries();
        Assertions.assertTrue((boolean)tables.isEmpty());
        ContentsKey key = ContentsKey.of((String[])new String[]{"x", "x"});
        this.tryEndpointPass(() -> this.contents.setContents(key, branch.getName(), branch.getHash(), "empty message", (Contents)IcebergTable.of((String)"foo")));
        IcebergTable table = (IcebergTable)this.contents.getContents(key, "testx").unwrap(IcebergTable.class).get();
        Branch master = (Branch)this.tree.getReferenceByName("testx");
        ImmutableBranch test = ImmutableBranch.builder().hash(master.getHash()).name("testy").build();
        this.tryEndpointPass(() -> this.lambda$testAdmin$2((Branch)test));
        Branch test2 = (Branch)this.tree.getReferenceByName("testy");
        this.tryEndpointPass(() -> this.tree.deleteBranch(test2.getName(), test2.getHash()));
        this.tryEndpointPass(() -> this.contents.deleteContents(key, master.getName(), master.getHash(), ""));
        Assertions.assertThrows(NessieNotFoundException.class, () -> this.contents.getContents(key, "testx"));
        this.tryEndpointPass(() -> this.contents.setContents(key, branch.getName(), branch.getHash(), "", (Contents)IcebergTable.of((String)"bar")));
    }

    @Test
    @TestSecurity(authorizationEnabled=false)
    void testUserCleanup() throws NessieNotFoundException, NessieConflictException {
        this.getCatalog(null);
        Reference r = this.client.getTreeApi().getReferenceByName("testx");
        this.client.getTreeApi().deleteBranch(r.getName(), r.getHash());
    }

    private IcebergTable createTable(String name, String location) {
        return ImmutableIcebergTable.builder().metadataLocation("xxx").build();
    }

    private /* synthetic */ void lambda$testAdmin$2(Branch test) throws Throwable {
        this.tree.createReference((Reference)Branch.of((String)test.getName(), (String)test.getHash()));
    }

    static interface RunnableIO {
        public void run() throws IOException;
    }
}

