/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.projectnessie.client.NessieClient;

public abstract class BaseClientAuthTest {
    private NessieClient client;
    private Consumer<NessieClient.Builder> customizer;

    @AfterEach
    void closeClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    protected void withClientCustomizer(Consumer<NessieClient.Builder> customizer) {
        this.customizer = customizer;
    }

    protected NessieClient client() {
        if (this.client != null) {
            return this.client;
        }
        NessieClient.Builder builder = NessieClient.builder().withUri("http://localhost:19121/api/v1");
        if (this.customizer != null) {
            this.customizer.accept(builder);
        }
        this.client = builder.build();
        return this.client;
    }
}

