/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.security.TestSecurity;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.client.NessieClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableDelete;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;

@QuarkusTest
class TestBasicOperations {
    private NessieClient client;
    private TreeApi tree;
    private ContentsApi contents;

    TestBasicOperations() {
    }

    @AfterEach
    void closeClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    void getCatalog(String branch) throws NessieNotFoundException, NessieConflictException {
        this.client = NessieClient.builder().withUri("http://localhost:19121/api/v1").build();
        this.tree = this.client.getTreeApi();
        this.contents = this.client.getContentsApi();
        if (branch != null) {
            this.tree.createReference((Reference)Branch.of((String)branch, null));
        }
    }

    void tryEndpointPass(Executable runnable) {
        Assertions.assertDoesNotThrow((Executable)runnable);
    }

    @Test
    @TestSecurity(user="admin_user", roles={"admin", "user"})
    void testAdmin() throws NessieNotFoundException, NessieConflictException {
        this.getCatalog("testx");
        Branch branch = (Branch)this.tree.getReferenceByName("testx");
        List tables = this.tree.getEntries("testx", EntriesParams.empty()).getEntries();
        Assertions.assertTrue((boolean)tables.isEmpty());
        ContentsKey key = ContentsKey.of((String[])new String[]{"x", "x"});
        this.tryEndpointPass(() -> this.tree.commitMultipleOperations(branch.getName(), branch.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(key).contents((Contents)IcebergTable.of((String)"foo")).build()).commitMeta(CommitMeta.fromMessage((String)"empty message")).build()));
        Assertions.assertTrue((boolean)this.contents.getContents(key, "testx", null).unwrap(IcebergTable.class).isPresent());
        Branch master = (Branch)this.tree.getReferenceByName("testx");
        ImmutableBranch test = ImmutableBranch.builder().hash(master.getHash()).name("testy").build();
        this.tryEndpointPass(() -> this.lambda$testAdmin$1((Branch)test));
        Branch test2 = (Branch)this.tree.getReferenceByName("testy");
        this.tryEndpointPass(() -> this.tree.deleteBranch(test2.getName(), test2.getHash()));
        this.tryEndpointPass(() -> this.tree.commitMultipleOperations(master.getName(), master.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutableDelete.builder().key(key).build()).commitMeta(CommitMeta.fromMessage((String)"")).build()));
        Assertions.assertThrows(NessieNotFoundException.class, () -> this.contents.getContents(key, "testx", null));
        this.tryEndpointPass(() -> this.tree.commitMultipleOperations(branch.getName(), branch.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(key).contents((Contents)IcebergTable.of((String)"bar")).build()).commitMeta(CommitMeta.fromMessage((String)"")).build()));
    }

    @Test
    @TestSecurity(authorizationEnabled=false)
    void testUserCleanup() throws NessieNotFoundException, NessieConflictException {
        this.getCatalog(null);
        Reference r = this.client.getTreeApi().getReferenceByName("testx");
        this.client.getTreeApi().deleteBranch(r.getName(), r.getHash());
    }

    private /* synthetic */ void lambda$testAdmin$1(Branch test) throws Throwable {
        this.tree.createReference((Reference)Branch.of((String)test.getName(), (String)test.getHash()));
    }
}

