/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.security.TestSecurity;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.client.rest.NessieForbiddenException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableDelete;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.server.BaseClientAuthTest;
import org.projectnessie.server.authz.NessieAuthorizationTestProfile;

@QuarkusTest
@TestProfile(value=NessieAuthorizationTestProfile.class)
class TestAuthorizationRules
extends BaseClientAuthTest {
    private TreeApi tree;
    private ContentsApi contents;

    TestAuthorizationRules() {
    }

    @BeforeEach
    void setupClient() {
        this.tree = this.client().getTreeApi();
        this.contents = this.client().getContentsApi();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @TestSecurity(user="test_user")
    void testAllOpsWithTestUser(boolean shouldFail) throws NessieNotFoundException, NessieConflictException {
        this.testAllOps("allowedBranchForTestUser", "test_user", shouldFail);
    }

    @Test
    @TestSecurity(user="admin_user")
    void testAdminUserIsAllowedEverything() throws NessieNotFoundException, NessieConflictException {
        this.testAllOps("testAdminUserIsAllowedAllBranch", "admin_user", false);
    }

    private void testAllOps(String branchName, String role, boolean shouldFail) throws NessieConflictException, NessieNotFoundException {
        ContentsKey key = ContentsKey.of((String[])new String[]{"allowed", "x"});
        if (shouldFail) {
            branchName = "disallowedBranchForTestUser";
            key = ContentsKey.of((String[])new String[]{"disallowed", "x"});
        }
        this.createBranch(Branch.of((String)branchName, null), role, shouldFail);
        Branch branchWithInvalidHash = Branch.of((String)branchName, (String)"1234567890123456");
        Branch branch = shouldFail ? branchWithInvalidHash : this.retrieveBranch(branchName, role, shouldFail);
        this.listAllReferences(branchName, shouldFail);
        ImmutableOperations createOps = ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(key).contents((Contents)IcebergTable.of((String)"foo")).build()).commitMeta(CommitMeta.fromMessage((String)"add stuff")).build();
        this.addContent(branch, (Operations)createOps, role, shouldFail);
        this.getCommitLog(branchName, role, shouldFail);
        this.getEntriesFor(branchName, role, shouldFail);
        this.readContent(branchName, key, role, shouldFail);
        branch = shouldFail ? branchWithInvalidHash : this.retrieveBranch(branchName, role, shouldFail);
        ImmutableOperations deleteOps = ImmutableOperations.builder().addOperations((Operation)ImmutableDelete.builder().key(key).build()).commitMeta(CommitMeta.fromMessage((String)"delete stuff")).build();
        this.deleteContent(branch, (Operations)deleteOps, role, shouldFail);
        branch = shouldFail ? branchWithInvalidHash : this.retrieveBranch(branchName, role, shouldFail);
        this.deleteBranch(branch, role, shouldFail);
    }

    @Test
    @TestSecurity(user="test_user2")
    void testCanCommitButNotUpdateOrDeleteEntity() throws NessieNotFoundException, NessieConflictException {
        String role = "test_user2";
        ContentsKey key = ContentsKey.of((String[])new String[]{"allowed", "some"});
        String branchName = "allowedBranchForTestUser2";
        this.createBranch(Branch.of((String)branchName, null), role, false);
        this.listAllReferences(branchName, false);
        Branch branch = this.retrieveBranch(branchName, role, false);
        ImmutableOperations createOps = ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(key).contents((Contents)IcebergTable.of((String)"foo")).build()).commitMeta(CommitMeta.fromMessage((String)"add stuff")).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.commitMultipleOperations(branch.getName(), branch.getHash(), (Operations)createOps)).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'UPDATE_ENTITY' is not allowed for role '%s' on content '%s'", role, ((Operation)createOps.getOperations().get(0)).getKey().toPathString()));
        this.readContent(branchName, key, role, true);
        Branch b = this.retrieveBranch(branchName, role, false);
        ImmutableOperations deleteOps = ImmutableOperations.builder().addOperations((Operation)ImmutableDelete.builder().key(key).build()).commitMeta(CommitMeta.fromMessage((String)"delete stuff")).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.commitMultipleOperations(b.getName(), b.getHash(), (Operations)deleteOps)).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'DELETE_ENTITY' is not allowed for role '%s' on content '%s'", role, ((Operation)deleteOps.getOperations().get(0)).getKey().toPathString()));
        this.deleteBranch(branch, role, false);
    }

    private void listAllReferences(String branchName, boolean filteredOut) {
        if (filteredOut) {
            Assertions.assertThat((List)this.tree.getAllReferences()).extracting(Reference::getName).doesNotContain((Object[])new String[]{branchName});
        } else {
            Assertions.assertThat((List)this.tree.getAllReferences()).extracting(Reference::getName).contains((Object[])new String[]{branchName});
        }
    }

    private Branch retrieveBranch(String branchName, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getReferenceByName(branchName)).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'VIEW_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branchName));
            return null;
        }
        return (Branch)this.tree.getReferenceByName(branchName);
    }

    private void createBranch(Branch branch, String role, boolean shouldFail) throws NessieConflictException, NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.createReference((Reference)branch)).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'CREATE_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            this.tree.createReference((Reference)branch);
        }
    }

    private void deleteBranch(Branch branch, String role, boolean shouldFail) throws NessieConflictException, NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.deleteBranch(branch.getName(), branch.getHash())).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'DELETE_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            this.tree.deleteBranch(branch.getName(), branch.getHash());
        }
    }

    private void readContent(String branchName, ContentsKey key, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.contents.getContents(key, branchName, null).unwrap(IcebergTable.class).get()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'READ_ENTITY_VALUE' is not allowed for role '%s' on content '%s'", role, key.toPathString()));
        } else {
            ((ObjectAssert)Assertions.assertThat((Object)((IcebergTable)this.contents.getContents(key, branchName, null).unwrap(IcebergTable.class).get())).isNotNull()).isInstanceOf(IcebergTable.class);
        }
    }

    private void getEntriesFor(String branchName, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getEntries(branchName, EntriesParams.empty()).getEntries()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'READ_ENTRIES' is not allowed for role '%s' on reference", role));
        } else {
            List tables = this.tree.getEntries(branchName, EntriesParams.empty()).getEntries();
            Assertions.assertThat((List)tables).isNotEmpty();
        }
    }

    private void getCommitLog(String branchName, String role, boolean shouldFail) throws NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getCommitLog(branchName, CommitLogParams.empty()).getOperations()).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'LIST_COMMIT_LOG' is not allowed for role '%s' on reference", role));
        } else {
            List commits = this.tree.getCommitLog(branchName, CommitLogParams.empty()).getOperations();
            Assertions.assertThat((List)commits).isNotEmpty();
        }
    }

    private void addContent(Branch branch, Operations operations, String role, boolean shouldFail) throws NessieNotFoundException, NessieConflictException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.commitMultipleOperations(branch.getName(), branch.getHash(), operations)).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'COMMIT_CHANGE_AGAINST_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            this.tree.commitMultipleOperations(branch.getName(), branch.getHash(), operations);
        }
    }

    private void deleteContent(Branch branch, Operations operations, String role, boolean shouldFail) throws NessieConflictException, NessieNotFoundException {
        if (shouldFail) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.commitMultipleOperations(branch.getName(), branch.getHash(), operations)).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(String.format("'COMMIT_CHANGE_AGAINST_REFERENCE' is not allowed for role '%s' on reference '%s'", role, branch.getName()));
        } else {
            this.tree.commitMultipleOperations(branch.getName(), branch.getHash(), operations);
        }
    }
}

